ExtendedSprayer = {}
function ExtendedSprayer.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Sprayer, specializations)
end
function ExtendedSprayer:load(xmlFile)
  self.setIsTurnedOn = Utils.prependedFunction(self.setIsTurnedOn, ExtendedSprayer.setIsTurnedOn)
  if self.isClient then
    local i = 0
    while true do
      do
        local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i)
        local node = getXMLString(xmlFile, baseName .. "#index")
        if node == nil then
          break
        end
        local particle = self.sprayValves[i + 1]
        ParticleSystemUtil.loadParticleSystemDesc(particle, self, xmlFile, baseName)
        i = i + 1
        ParticleSystemUtil.updateParticleSystem(particle, self, false)
      end
    end
    self.particlePlanes = ShaderParticleSystem.load(xmlFile, "vehicle.particlePlane", self)
  end
end
function ExtendedSprayer:delete()
end
function ExtendedSprayer:mouseEvent(posX, posY, isDown, isUp, button)
end
function ExtendedSprayer:keyEvent(unicode, sym, modifier, isDown)
end
function ExtendedSprayer:update(dt)
end
function ExtendedSprayer:updateTick(dt)
  if self:getIsActive() and self.isTurnedOn then
    for _, ps in pairs(self.sprayValves) do
      ParticleSystemUtil.updateParticleSystem(ps, self, false)
    end
  end
  if self.particlePlanes ~= nil then
    ShaderParticleSystem.updateParticle(self.particlePlanes, dt)
  end
end
function ExtendedSprayer:draw()
end
function ExtendedSprayer:setIsTurnedOn(isTurnedOn, noEventSend)
  if isTurnedOn ~= self.isTurnedOn and self:getIsTurnedOnAllowed(isTurnedOn) and self.particlePlanes ~= nil then
    ShaderParticleSystem.setIsTurnedOn(self.particlePlanes, isTurnedOn)
  end
end

