--
-- Show workers on PDA-map
--
-- @author  Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com
-- @date    2011-04-19
--
-- @history
--      v0.9(beta)  Public release, only tested in singleplayer and patch 2.3.
--      v0.91(beta) Fix for updating position too often, as it seems to have a negative impact in multiplayer.
--      v0.92(beta) Changed to use; <originalFunc>=Utils.appendedFunction(<originalFunc>,<addedFunc>)
--      v0.93(beta) Added "worker-icons" for CoursePlay v2.4 controlled vehicles
--      v0.94(beta) Fix for when CoursePlay v2.4 is loaded after this script. Now using ModEventListener and update() to make a delayed call to Utils.appendedFunction()
--  2013-march
--      v0.95   - Upgraded to FS13, and added detection of FollowMe2013.
--  2013-june
--      v0.96   - Code cleanup.
--              - Seems to still work with CoursePlay v3.41
--

ShowWorkersOnPDA = {};
ShowWorkersOnPDA.version = 0.96;    -- Using floating-point for version-number? Not wise, but its going to do for now.
ShowWorkersOnPDA.circleYellow = Utils.getFilename("icon_yellow.dds", g_currentModDirectory);

function ShowWorkersOnPDA.addWorkerIconOnPda(self)
    if self.modWorkerIconPda == nil then
        local x,y,z = getWorldTranslation(self.components[1].node);
        local iconSize = g_currentMission.missionPDA.pdaMapWidth / 24;
        self.modWorkerIconPda = g_currentMission.missionPDA:createMapHotspot(
            "",   -- name of hotspot
            ShowWorkersOnPDA.circleYellow,  -- icon-filename
            0, -- x-position
            0, -- y-position
            iconSize,            -- width
            iconSize * (4 / 3),  -- height
            false,  -- Blinking icon
            false,  -- Show on PDA-map-edges
            false,  -- ?
            self.components[1].node, -- Object to track automatically
            false   -- ?
        );
    else
        self.modWorkerIconPda.enabled = true;
    end;
end;

-- Steerable additions
function ShowWorkersOnPDA.deleteSteerable(self)
  if (self.modWorkerIconPda ~= nil) then
    g_currentMission.missionPDA:deleteMapHotspot(self.modWorkerIconPda);
  end;
end;

Steerable.delete = Utils.prependedFunction(Steerable.delete, ShowWorkersOnPDA.deleteSteerable);


-- Hirable additions
function ShowWorkersOnPDA.hire(self)
    if self.isHired then
        ShowWorkersOnPDA.addWorkerIconOnPda(self);
    end;
end;

function ShowWorkersOnPDA.dismiss(self)
    if self.modWorkerIconPda ~= nil then
        self.modWorkerIconPda.enabled = false;
    end;
end;

Hirable.hire    = Utils.appendedFunction(Hirable.hire,    ShowWorkersOnPDA.hire);
Hirable.dismiss = Utils.appendedFunction(Hirable.dismiss, ShowWorkersOnPDA.dismiss);


-- CoursePlay additions
function ShowWorkersOnPDA.cpStart(self2, self)   -- Why 'self2' and 'self'? That depends on . or :    See more on http://lua-users.org/wiki/ColonForMethodCall
    if (self.drive) then
        ShowWorkersOnPDA.addWorkerIconOnPda(self);
    end;
end;

function ShowWorkersOnPDA.cpStop(self2, self)    -- Why 'self2' and 'self'? That depends on . or :    See more on http://lua-users.org/wiki/ColonForMethodCall
    if self.modWorkerIconPda ~= nil then
        self.modWorkerIconPda.enabled = false;
    end;
end;

-- FollowMe additions
function ShowWorkersOnPDA.fmStart(self, noSendEvent)
    if (self.modFM ~= nil and self.modFM.FollowVehicleObj ~= nil) then
        ShowWorkersOnPDA.addWorkerIconOnPda(self);
    end;
end;

function ShowWorkersOnPDA.fmStop(self, noSendEvent)
    if self.modWorkerIconPda ~= nil then
        self.modWorkerIconPda.enabled = false;
    end;
end;

-- Detect if courseplay has also been loaded, so its start() and stop() functions can be appended to.
function ShowWorkersOnPDA:loadMap(name)
    ShowWorkersOnPDA.checkCourseplay = true
    ShowWorkersOnPDA.checkFollowMe = true
end;

function ShowWorkersOnPDA:deleteMap()
end;

function ShowWorkersOnPDA:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowWorkersOnPDA:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowWorkersOnPDA:update(dt)
    if (ShowWorkersOnPDA.checkCourseplay) then
        ShowWorkersOnPDA.checkCourseplay = false;
        --
        -- Try to detect if the courseplay mod is loaded by the game, by assuming that when 'courseplay' is defined it is.
        if (courseplay ~= nil) then
            print("ShowWorkersOnPDA: Detected 'courseplay' mod. Appending start/stop functions for show-workers-on-PDA.");
            courseplay.start  = Utils.appendedFunction(courseplay.start,  ShowWorkersOnPDA.cpStart);
            courseplay.stop   = Utils.appendedFunction(courseplay.stop,   ShowWorkersOnPDA.cpStop);
        end;
    end;
    if (ShowWorkersOnPDA.checkFollowMe) then
        ShowWorkersOnPDA.checkFollowMe = false;
        --
        -- Try to detect if the FollowMe mod is loaded by the game, by assuming that when 'FollowMe2013' is defined it is.
        if (FollowMe2013 ~= nil and FollowMe2013.FollowMe ~= nil) then
            print("ShowWorkersOnPDA: Detected 'FollowMe2013' mod. Appending start/stop functions for show-workers-on-PDA.");
            FollowMe2013.FollowMe.startFollowMe  = Utils.appendedFunction(FollowMe2013.FollowMe.startFollowMe,  ShowWorkersOnPDA.fmStart);
            FollowMe2013.FollowMe.stopFollowMe   = Utils.appendedFunction(FollowMe2013.FollowMe.stopFollowMe,   ShowWorkersOnPDA.fmStop);
        end
    end;
end;

function ShowWorkersOnPDA:draw()
end;

--
addModEventListener(ShowWorkersOnPDA);

--
print(string.format("Script loaded: ShowWorkersOnPDA.lua (v%.2f)", ShowWorkersOnPDA.version));
