wheelMode = {};

function wheelMode.prerequisitesPresent(specializations)
	return true;
end;

function wheelMode:load(xmlFile)

	self.changeWheel = 1;
	self.WheelBackup = {}
    for i=1, table.getn(self.wheels) do
		self.WheelBackup[i] = self.wheels[i].rotSpeed;
    end;
end;

function wheelMode:delete()
end;

function wheelMode:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelMode:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelMode:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ClaasScorpion_WHEELMODE) then
			self.changeWheel = self.changeWheel+1;
		end;
	end;
	if self:getIsActive() then
		if self.changeWheel == 0  then
			self.wheels[1].rotSpeed = self.WheelBackup[1];
			self.wheels[2].rotSpeed = self.WheelBackup[2];
			self.wheels[3].rotSpeed = self.WheelBackup[3];
			self.wheels[4].rotSpeed = self.WheelBackup[4];
		elseif self.changeWheel == 1  then
			self.wheels[1].rotSpeed = self.WheelBackup[1];
			self.wheels[2].rotSpeed = self.WheelBackup[2];
			self.wheels[3].rotSpeed = 0;
			self.wheels[4].rotSpeed = 0;
		elseif self.changeWheel == 2  then
			self.wheels[1].rotSpeed = 0;
			self.wheels[2].rotSpeed = 0;
			self.wheels[3].rotSpeed = self.WheelBackup[3];
			self.wheels[4].rotSpeed = self.WheelBackup[4];
		elseif self.changeWheel == 3 then
			self.changeWheel = 0;
		end;
	end;
end;

function wheelMode:draw()	
	if self.changeWheel == 0  then
		g_currentMission:addExtraPrintText(""..string.format("%s: Steering: All Wheels", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ClaasScorpion_WHEELMODE)).."");
	elseif self.changeWheel == 1  then
		g_currentMission:addExtraPrintText(""..string.format("%s: Steering: Front Wheels", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ClaasScorpion_WHEELMODE)).."");
	elseif self.changeWheel == 2  then
		g_currentMission:addExtraPrintText(""..string.format("%s: Steering: Back Wheels", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ClaasScorpion_WHEELMODE)).."");
	end;
end;