-- by modelleicher
-- www.schwabenmodding.bplaced.net
--[[ XML EINTRGE:
<visByAttObj reverseAttacherNum="false" >
	<Fronthydraulik Zugmaul="" Stossstange="" Oberlenker="" />
	<Heckhydraulik Zugmaul="" Ackerschiene="" Oberlenker="" />
</visByAttObj>
]]

visibilityByAttachedObject = {};

function visibilityByAttachedObject.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function visibilityByAttachedObject:load(xmlFile)
	self.setZv1State = visibilityByAttachedObject.setZv1State;
	self.setZv2State = visibilityByAttachedObject.setZv2State;
	
	self.reverseAttacherNum = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.visByAttObj#reverseAttacherNum"), false);
	
	self.fcZugmaul = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visByAttObj.Fronthydraulik#Zugmaul"));
	self.fcStossstange = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visByAttObj.Fronthydraulik#Stossstange"));
	self.fcOberlenker = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visByAttObj.Fronthydraulik#Oberlenker"));
	
	self.bcZugmaul = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visByAttObj.Heckhydraulik#Zugmaul"));
	self.bcAckerschiene = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visByAttObj.Heckhydraulik#Ackerschiene"));
	self.bcOberlenker = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.visByAttObj.Heckhydraulik#Oberlenker"));
	
	--	Trac 1900 modification 
	self.frontTrailerAttacherNumber = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.visByAttObj#reverseAttacherNum"), 3);
	self.fcStossstangeOn = true;
	--
	self:setZv1State(0);
	self:setZv2State(0);	
end;
function visibilityByAttachedObject:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local attacherIndex = implement.jointDescIndex;
	if attacherIndex == 1 then
		if not self.reverseAttacherNum then
			self:setZv1State(1);
		else
			self:setZv2State(1);
		end;
	end;
	if attacherIndex == 2 then
		if not self.reverseAttacherNum then
			self:setZv2State(1);
		else
			self:setZv1State(1);
		end;
	end;
	
	-- Trac 1900 modification
	if attacherIndex == self.frontTrailerAttacherNumber then
		self.fcStossstangeOn = false;
	end;
	--
	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		setVisibility(self.bcAckerschiene, false);
	end;
end;
function visibilityByAttachedObject:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local attacherIndex = implement.jointDescIndex;
	local jointType = implement.object.attacherJoint.jointType;	
    if attacherIndex == 1 then
		if not self.reverseAttacherNum then
			self:setZv1State(0);
		else
			self:setZv2State(0);
		end;
	end;
    if attacherIndex == 2 then
		if not self.reverseAttacherNum then
			self:setZv2State(0);
		else
			self:setZv1State(0);
		end;
	end;	
	
	-- Trac 1900 modification
	if attacherIndex == self.frontTrailerAttacherNumber then
		self.fcStossstangeOn = true;
	end;
	--
	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		setVisibility(self.bcAckerschiene, true);
	end;	
end;
function visibilityByAttachedObject:setZv1State(currentState)
	if currentState == 0 then
		if self.fcZugmaul ~= nil then
			setVisibility(self.fcZugmaul, true);
		end;
		if self.fcStossstange ~= nil then
			self.fcStossstangeOn = true;
		end;
		if self.fcOberlenker ~= nil then
			setVisibility(self.fcOberlenker, false);
		end;
	else
		if self.fcZugmaul ~= nil then
			setVisibility(self.fcZugmaul, false);
		end;
		if self.fcStossstange ~= nil then
			self.fcStossstangeOn = false;
		end;
		if self.fcOberlenker ~= nil then
			setVisibility(self.fcOberlenker, true);
		end;
	end;
end;
function visibilityByAttachedObject:setZv2State(currentState)
	if currentState == 0 then
		if self.bcZugmaul ~= nil then
			setVisibility(self.bcZugmaul, true);
		end;
		if self.bcAckerschiene ~= nil then
			setVisibility(self.bcAckerschiene, true);
		end;
		if self.bcOberlenker ~= nil then
			setVisibility(self.bcOberlenker, false);
		end;
	else
		if self.bcZugmaul ~= nil then
			setVisibility(self.bcZugmaul, false);
		end;
		if self.bcAckerschiene ~= nil then
			setVisibility(self.bcAckerschiene, false);
		end;
		if self.bcOberlenker ~= nil then
			setVisibility(self.bcOberlenker, true);
		end;
	end;
end;
function visibilityByAttachedObject:update(dt)
	if self:getIsActive() then
		if self.fcStossstangeOn then
			setVisibility(self.fcStossstange, true);
		else
			setVisibility(self.fcStossstange, false);
		end;
	end;
end;
function visibilityByAttachedObject:draw()
end;
function visibilityByAttachedObject:delete()
end;
function visibilityByAttachedObject:mouseEvent(posX, posY, isDown, isUp, button)
end;
function visibilityByAttachedObject:keyEvent(unicode, sym, modifier, isDown)   
end;