-- by modelleicher
-- www.schwabenmodding.bplaced.net

bcMoveUpByAttachedTrailer = {};

function bcMoveUpByAttachedTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function bcMoveUpByAttachedTrailer:load(xmlFile)
	self.lowAttacherDescIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.bcMoveUpByAttachedTrailer#lowAttacherDescIndex"), 0);
	self.backCouplerRotUpPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bcMoveUpByAttachedTrailer#backCouplerIndex"));
	self.maxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.bcMoveUpByAttachedTrailer#maxRot"));
		
	self.hasLowTrailerAttached = false;
	
	local rV = {};
	rV.maxRot = {};
	rV.maxRot[1] = Utils.degToRad(self.maxRot)
	rV.maxRot[2] = Utils.degToRad(0);
	rV.maxRot[3] = Utils.degToRad(0);
	rV.minRot = {};
	rV.minRot[1], rV.minRot[2], rV.minRot[3] = getRotation(self.backCouplerRotUpPart);
	
	rV.rotTime =  Utils.getNoNil(getXMLString(xmlFile, "vehicle.bcMoveUpByAttachedTrailer#rotTime"), 1)*1000;
	self.bcRotValues = rV;

end;
function bcMoveUpByAttachedTrailer:delete()
end;
function bcMoveUpByAttachedTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;
function bcMoveUpByAttachedTrailer:keyEvent(unicode, sym, modifier, isDown)
end;
function bcMoveUpByAttachedTrailer:updateTick(dt)
end;
function bcMoveUpByAttachedTrailer:update(dt)	
	if self:getIsActive() then
		if self.hasLowTrailerAttached then
			local x, y, z = getRotation(self.backCouplerRotUpPart);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.bcRotValues.maxRot, self.bcRotValues.minRot, 3, self.bcRotValues.rotTime, dt, false);
			setRotation(self.backCouplerRotUpPart, unpack(newRot));		
		else
			local x, y, z = getRotation(self.backCouplerRotUpPart);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.bcRotValues.maxRot, self.bcRotValues.minRot, 3, self.bcRotValues.rotTime, dt, true);
			setRotation(self.backCouplerRotUpPart, unpack(newRot));	
		end;
	end;
end;	
function bcMoveUpByAttachedTrailer:draw()
end;
function bcMoveUpByAttachedTrailer:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		self.hasLowTrailerAttached = true;
	end;
end;

function bcMoveUpByAttachedTrailer:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	local jointType = implement.object.attacherJoint.jointType;
	
	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		self.hasLowTrailerAttached = false;
	end;
end;
