--
-- mooringblocks
--
-- @author  Geri-G 
-- @date  31/07/10
--
-- Copyright (C) Geri-G
--
-- @edit fruktor
--

mooringblocks = {};

Vehicle.registerJointType("SchlueterProfiTracGewicht");

function mooringblocks.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function mooringblocks:load(xmlFile)

	self.changeBlocks = SpecializationUtil.callSpecializationsFunction("changeBlocks");

	self.disabledBlocks = {};
	self.enabledBlocks = {};
	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.mooringblocks.enabled.mooringblock(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		local entry = {};
		
		entry.node = Utils.indexToObject(self.components, nodeStrg);
		entry.trans = {getTranslation(entry.node)};
		entry.rot = {getRotation(entry.node)};
		entry.oldParent = getParent(entry.node);
		table.insert(self.enabledBlocks,entry);
		setRigidBodyType(entry.node,"None");
		i = i+1;
	end;	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.mooringblocks.disabled.mooringblock(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, nodeStrg);
		table.insert(self.disabledBlocks,node);
		i = i+1;
	end;

	self:changeBlocks(false);
end;

function mooringblocks:delete()

end;

function mooringblocks:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mooringblocks:keyEvent(unicode, sym, modifier, isDown)
end;

function mooringblocks:update(dt)
end;

function mooringblocks:draw()
end;

function mooringblocks:onAttach(attacherVehicle)
	self:changeBlocks(true);
end;

function mooringblocks:onDetach()
	self:changeBlocks(false);
end;

function mooringblocks:changeBlocks(enabled)
	if enabled == false then
		for k,v in pairs(self.disabledBlocks) do
			setVisibility(v, false);
		end;	
		for k,v in pairs(self.enabledBlocks) do
			setVisibility(v.node, true);
			--local x,y,z = getWorldTranslation(v.node);
			--local x1,y1,z1 = getWorldRotation(v.node);
			--link(getRootNode(),v.node);
			--setTranslation(v.node,x,y,z);
			--setRotation(v.node,x1,y1,z1);
			--setRigidBodyType(v.node,"Static");
		end;
	elseif enabled == true then
		for k,v in pairs(self.disabledBlocks) do
			setVisibility(v, true);
		end;	
		for k,v in pairs(self.enabledBlocks) do
			setVisibility(v.node, false);
			--setRigidBodyType(v.node,"None");
			--link(v.oldParent,v.node);
			--setTranslation(v.node,unpack(v.trans));
			--setRotation(v.node,unpack(v.rot));
		end;
	end;
end;

function mooringblocks:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    return BaseMission.VEHICLE_LOAD_OK;
end;

function mooringblocks:getSaveAttributesAndNodes(nodeIdent)
end;