--
-- BJR_MovingPartsInterior
-- Specialization for BJR_MovingPartsInterior 
--
-- @author  	JoXXer
-- @date  		27/03/13
--

BJR_MovingPartsInterior = {};

function BJR_MovingPartsInterior.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BJR_MovingPartsInterior:load(xmlFile)
	self.clutchPedal = {};
	self.clutchPedal.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.clutchPedal#index"));
	self.clutchPedal.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#maxRot"), 0));
	self.clutchPedal.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#minRot"), 0));
	self.clutchPedal.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#movementSpeed"), 0)/1000;
	
	self.footThrottle = {};
	self.footThrottle.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.footThrottle#index"));
end;

function BJR_MovingPartsInterior:delete()

end;

function BJR_MovingPartsInterior:readStream(streamId, connection)
end;

function BJR_MovingPartsInterior:writeStream(streamId, connection)
end;

function BJR_MovingPartsInterior:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_MovingPartsInterior:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_MovingPartsInterior:update(dt)

	if self:getIsActive() then
	
		if self.lastAcceleration ~= 0 then
			if self.footThrottle.index ~= nil then
				local footThrottleMovement = self.lastAcceleration/4;
				if footThrottleMovement < 0 then
					footThrottleMovement = -footThrottleMovement;
				end;
				setRotation(self.footThrottle.index, -footThrottleMovement, 0, 0);
			end;
		end;
		
		if self.ignitionMode == nil or self.ignitionMode >= 1 then


			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 or self.lastAcceleration == 0 then
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX > self.clutchPedal.maxRot then
						setRotation(self.clutchPedal.index, rotX - dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			else
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX < self.clutchPedal.minRot then
						setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			end;

		else
			if self.clutchPedal.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
				if rotX < self.clutchPedal.minRot then
					setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
				end;
			end;
		end;
	end;
end;

function BJR_MovingPartsInterior:updateTick(dt)

end;

function BJR_MovingPartsInterior:draw()

end;