--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.30, 0.02, "Taste Numpad 0: Info Einschalten");
	 else
		renderText(0.72, 0.30, 0.02, "Taste Numpad 0: Info Abschalten");
		renderText(0.72, 0.75, 0.02, "- Scania R700 New Abschlepper -");
		renderText(0.72, 0.73, 0.02, "Taste R: Blitzer");
		renderText(0.72, 0.71, 0.02, "Taste Numpad 1: Blinker links");
		renderText(0.72, 0.69, 0.02, "Taste Numpad 2: Warnblinker");
		renderText(0.72, 0.67, 0.02, "Taste Numpad 3: Blinker rechts");
		renderText(0.72, 0.65, 0.02, "Taste 5: Rulbalken Hoch/Runter");
		renderText(0.72, 0.63, 0.02, "Taste v: Hauptarm Hoch/Runter");
		renderText(0.72, 0.61, 0.02, "Taste b: Tragearm Aus/Einklappen");
		renderText(0.72, 0.59, 0.02, "KEY_6 KEY_lshift: Ausschub1 Aus/Ein");
		renderText(0.72, 0.57, 0.02, "KEY_7 KEY_lshift: Ausschub2 Aus/Ein");
		renderText(0.72, 0.55, 0.02, "Taste 8: Stuetze  Aus/Einfahren");
		renderText(0.72, 0.53, 0.02, "- Stuetzplatten benutzen -");
		renderText(0.72, 0.51, 0.02, "Taste 0: Hupe");
		   
	end;
end;  

function ShowHelp:onLeave()
	self.showHelp = false;
end;




