--
-- NHPowerCommand
-- Specialization for NHPowerCommand gearbox
--
-- @author  JoXXer
-- @date  21/09/11
--

TurboWistle = {};

function TurboWistle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TurboWistle:load(xmlFile)
	-- Set acceleration
	self.setLastAcceleration = SpecializationUtil.callSpecializationsFunction("setLastAcceleration");
	-- Turbowhistle
	local turboWhistle = getXMLString(xmlFile, "vehicle.turboWhistle#file");
	if turboWhistle ~= nil and turboWhistle ~= "" then
        turboWhistle = Utils.getFilename(turboWhistle, self.baseDirectory);
        self.turboWhistle = createSample("turboWhistle");
        self.playTurboWhistle = false;
		self.playedTurboWhistle = false;
        loadSample(self.turboWhistle, turboWhistle, false);
        self.turboWhistlePitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistle#pitchOffset"), 1);
        self.turboWhistleVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistle#volume"), 1);
    end;
	-- Turbowhistle interior
	local turboWhistleInterior = getXMLString(xmlFile, "vehicle.turboWhistleInterior#file");
	if turboWhistleInterior ~= nil and turboWhistleInterior ~= "" then
        turboWhistleInterior = Utils.getFilename(turboWhistleInterior, self.baseDirectory);
        self.turboWhistleInterior = createSample("turboWhistleInterior");
		self.playedTurboWhistleInterior = false;
        loadSample(self.turboWhistleInterior, turboWhistleInterior, false);
        self.turboWhistleInteriorPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistleInterior#pitchOffset"), 1);
        self.turboWhistleInteriorVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistleInterior#volume"), 1);
    end;
end;

function TurboWistle:delete()
	if self.turboWhistle ~= nil then
		delete(self.turboWhistle);
		self.playTurboWhistle = false;
	end;
	if self.turboWhistleInterior ~= nil then
		delete(self.turboWhistleInterior);
		self.playTurboWhistleInterior = false;
	end;
end;

function TurboWistle:readStream(streamId, connection)
end;

function TurboWistle:writeStream(streamId, connection)
end;

function TurboWistle:readUpdateStream(streamId, timestamp, connection)

end;

function TurboWistle:writeUpdateStream(streamId, connection, dirtyMask)

end;

function TurboWistle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TurboWistle:keyEvent(unicode, sym, modifier, isDown)
end;

function TurboWistle:update(dt)
end;

function TurboWistle:updateTick(dt)
					if self.updatedAcceleration > 0.6 and acceleration == 0 and self:getIsActiveForSound() then
				if self.powerCommandThrottlePercentage > self.powerCommandMinRpm/self.motorMaxRpmLimit[3] then
					self.playTurboWhistle = false;
				else
					self.playTurboWhistle = true;
				end;
			elseif acceleration > 0 then
				self.playTurboWhistle = false;
			end;
				-- Acceleration adjustment when gearing up or down and gearshift modes
						if acceleration > 0 and self.updatedAcceleration > 0 and self.myLastAcceleration > 0.6 then
							self.myLastAcceleration = self.myLastAcceleration - 0.1;
							if self.myLastAcceleration < 0.6 then
								self.myLastAcceleration = 0.6;
						elseif acceleration <= 0 then
					end;
					if self.turboWhistle ~= nil then
						local maxRpm  = self.motor.maxRpm[3];
						local rpmVolume = Utils.clamp(math.abs(roundPerSecond*60)/((maxRpm - self.motor.minRpm)), 0.0, 1.0);
						if self.playTurboWhistle and not self.playedTurboWhistle then
							playSample(self.turboWhistle, 1, self.turboWhistleVolume, 0);
							setSamplePitch(self.turboWhistle, self.turboWhistlePitchOffset);
							setSampleVolume(self.turboWhistle, rpmVolume);
							self.playedTurboWhistle = true;
						elseif not self.playTurboWhistle then
							stopSample(self.turboWhistle);
							self.playedTurboWhistle = false;
						end;
				else
					if self.turboWhistleInterior ~= nil then
						local maxRpm  = self.motor.maxRpm[3];
						local rpmVolume = Utils.clamp(math.abs(roundPerSecond*60)/((maxRpm - self.motor.minRpm)), 0.0, 1.0);
						if self.playTurboWhistle and not self.playedTurboWhistleInterior then
							playSample(self.turboWhistleInterior, 1, self.turboWhistleVolumeInterior, 0);
							setSamplePitch(self.turboWhistleInterior, self.turboWhistleInteriorPitchOffset);
							setSampleVolume(self.turboWhistleInterior, rpmVolume);
							self.playedTurboWhistleInterior = true;
						elseif not self.playTurboWhistle then
							stopSample(self.turboWhistleInterior);
							self.playedTurboWhistleInterior = false;
						end;
						-- Set the lastAcceleration on both server and client
			self.lastAcceleration = self.newAcceleration;
			if not self.isServer then
				g_client:getServerConnection():sendEvent(SetLastAccelerationEvent:new(self, self.newAcceleration));
			end;
			--RPM meter value
			if (self.updatedAcceleration * (self.motorMaxRpmLimit[3] * self.rpmCoefficient)) > self.powerCommandMinRpm then
				if (self.updatedAcceleration * (self.motorMaxRpmLimit[3] * self.rpmCoefficient)) < 2300 then
					self.rpmMeterValue = self.updatedAcceleration * (self.motorMaxRpmLimit[3] * self.rpmCoefficient);
				end;
			else
				self.rpmMeterValue = self.updatedAcceleration * self.motorMaxRpmLimit[3];
		end;
	end;
end;

function TurboWistle:draw()
end;

function TurboWistle:onLeave()
self.myLastAcceleration = 0;
end;

function TurboWistle:stopMotor()
self.myLastAcceleration = 0;
end;

function TurboWistle:stopSounds()
end;

function TurboWistle:startMotor()
end;

function TurboWistle:onEnter()
end;

function NHPowerCommand:setLastAcceleration(newAcceleration)
	self.lastAcceleration = newAcceleration;
			end;
		end;
	end;
end;