﻿--
-- Specialization for Cutter
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--
-- @edit for geringhoff corncutter by usxi7sd 09/2014

geringhoffcc = {};

function geringhoffcc.prerequisitesPresent(specializations)
    return true;
end;

function geringhoffcc:load(xmlFile)	
	self.geringhoffcc = {};
	self.geringhoffcc.speedScaleTime = 5000;
	self.geringhoffcc.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.geringhoffcc#speed"), 11);
	self.geringhoffcc.rollSpeedBackup = self.rollNodes[1].speed;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.backup = rollNode.speed;
		rollNode.speed = 0;
	end;		
end;

function geringhoffcc:delete()
end;
function geringhoffcc:readStream(streamId, connection)
end;
function geringhoffcc:writeStream(streamId, connection)
end;
function geringhoffcc:mouseEvent(posX, posY, isDown, isUp, button)
end;
function geringhoffcc:keyEvent(unicode, sym, modifier, isDown)
end;

function geringhoffcc:update(dt)
	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastCutterAreaBiggerZero));
	
	if self:getIsActive() and self.reelStarted then	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.geringhoffcc.speed, 1.5));
	
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.geringhoffcc.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.geringhoffcc.speed, 1.5));
		
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.geringhoffcc.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;	
end;                                                  

function geringhoffcc:updateTick(dt)		
end;
function geringhoffcc:draw()	
end;

function geringhoffcc:onAttach(attacherVehicle)
	self.combine = attacherVehicle;
end;
function geringhoffcc:onDetach()		
	self.combine = nil;
end; 

function geringhoffcc:onStartReel()
end;