﻿--
-- Specialization for Cutter
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--
-- @edit for geringhoff harveststar cutter by usxi7sd 09/2014

geringhoff = {};

function geringhoff.prerequisitesPresent(specializations)
    return true;
end;

function geringhoff:load(xmlFile)	
	self.geringhoff = {};
	self.geringhoff.speedScaleTime = 5000;
	self.geringhoff.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.geringhoff#speed"), 11);
	self.geringhoff.rollSpeedBackup = self.rollNodes[1].speed;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.backup = rollNode.speed;
		rollNode.speed = 0;
	end;		
end;

function geringhoff:delete()
end;
function geringhoff:readStream(streamId, connection)
end;
function geringhoff:writeStream(streamId, connection)
end;
function geringhoff:mouseEvent(posX, posY, isDown, isUp, button)
end;
function geringhoff:keyEvent(unicode, sym, modifier, isDown)
end;

function geringhoff:update(dt)
	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastCutterAreaBiggerZero));
	
	if self:getIsActive() and self.reelStarted then	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.geringhoff.speed, 1.5));
	
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.geringhoff.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.geringhoff.speed, 1.5));
		
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.geringhoff.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;	
end;                                                  

function geringhoff:updateTick(dt)		
end;

function geringhoff:draw()	
		local action1 = InputBinding.actions[InputBinding.HASPEL];
		local str1 = g_i18n:getText('HASPEL'):format(KeyboardHelper.getKeyNames(action1.keys1), KeyboardHelper.getKeyNames(action1.keys2));
		g_currentMission:addExtraPrintText(str1);
end;

function geringhoff:onAttach(attacherVehicle)
	self.combine = attacherVehicle;
end;

function geringhoff:onDetach()		
	self.combine = nil;
end; 

function geringhoff:onStartReel()
end;