--
-- ChopperSwitcher
-- Specialization for ChopperSwitcher
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

ChopperSwitcher = {};

ChopperSwitcher.CHOPPER_TRANSPORT = 0;
ChopperSwitcher.CHOPPER_STRAW = 1;
ChopperSwitcher.CHOPPER = 2;

function ChopperSwitcher.prerequisitesPresent(specializations)
    return true;
end;

function ChopperSwitcher:load(xmlFile)
	self.setIsStrawActive = SpecializationUtil.callSpecializationsFunction("setIsStrawActive");	
	self.isStrawActive = true;
	self.toggleChopperWarningTime = 0;
	self.isLoadingFromSaveGame = false;
	self.isStrawSwitch = false;
	self.chopperState = ChopperSwitcher.CHOPPER_TRANSPORT;
	self:setIsStrawActive(false, true);
end;

function ChopperSwitcher:delete()
end;

function ChopperSwitcher:readStream(streamId, connection)
	local isStrawActive = streamReadBool(streamId);
	self:setIsStrawActive(isStrawActive, true);
end;

function ChopperSwitcher:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isStrawActive);
end;

function ChopperSwitcher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChopperSwitcher:keyEvent(unicode, sym, modifier, isDown)
end;

function ChopperSwitcher:update(dt)
	if self:getIsActive() then	
		if self.isClient and self:getIsActiveForInput() and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.TOGGLE_CHOPPER) then
					if self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
						local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidInputFruitType];
						if fruitDesc.hasWindrow then
							self:setIsStrawActive(not self.isStrawActive);
						else
							self.toggleChopperWarningTime = self.time + 2000;
						end;
					else
						self:setIsStrawActive(not self.isStrawActive);				
					end;
			end;
		end;		
		
		if self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidInputFruitType];
			if not fruitDesc.hasWindrow then
				if self.isStrawActive then
					self:setIsStrawActive(false);
				end;			
			end;
		end;
		
		self.chopperActivated = not self.isStrawActive;
	end;
end;

function ChopperSwitcher:draw()
	if self:getIsActiveForInput() then
		local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidInputFruitType];	
		if self.lastValidInputFruitType == FruitUtil.FRUITTYPE_UNKNOWN or fruitDesc.hasWindrow then	
				if self.isStrawActive then
					g_currentMission:addHelpButtonText(g_i18n:getText("ENABLE_CHOPPER"), InputBinding.TOGGLE_CHOPPER);
				else	
					g_currentMission:addHelpButtonText(g_i18n:getText("DISABLE_CHOPPER"), InputBinding.TOGGLE_CHOPPER);
				end;
		end;
	end;
	-- for sampo
	local action1 = InputBinding.actions[InputBinding.KORNTANKDECKEL];
	local str1 = g_i18n:getText('KORNTANKDECKEL'):format(KeyboardHelper.getKeyNames(action1.keys1), KeyboardHelper.getKeyNames(action1.keys2));
	g_currentMission:addExtraPrintText(str1);
	--
	if self.toggleChopperWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("COULD_NOT_TOGGLE_CHOPPER"), 0.018, 0.033);
	end;
end;

function ChopperSwitcher:setTransportState(isTransportState)
end;

function ChopperSwitcher:addCutterArea(cutter, area, realArea, inputFruitType, fruitType)
    if area > 0 and (self.lastCuttersFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.lastCuttersArea == 0 or self.lastCuttersFruitType == fruitType) then	
        if not self.chopperActivated and not self.isStrawActive then
			self.chopperActivated = not self.isStrawActive;
			self.chopperEnableTime = nil;
            self.chopperDisableTime = nil;
        end;
		
		if self.isStrawSwitch then
			if self.isStrawActive then
				self.chopperDisableTime = 0;
				self.chopperEnableTime = nil;
				self.strawEnableTime = 0;
				self.strawDisableTime = nil;
			else
				self.chopperDisableTime = nil;
				self.chopperEnableTime = 0;
				self.strawEnableTime = nil;
				self.strawDisableTime = 0;
			end;
			self.isStrawSwitch = false;
		end;
	end;
end;

function ChopperSwitcher:setStrawPSEnabled(strawPSenabled, fruitTypeChanged, isSynchronized)
	if not self.isStrawActive then
		if strawPSenabled then
			self:setChopperPSEnabled(true, fruitTypeChanged, isSynchronized);
			self:setStrawPSEnabled(false, fruitTypeChanged, isSynchronized);
		end;
	end;
end;

function ChopperSwitcher:setChopperState(state)
end;

function ChopperSwitcher:setIsStrawActive(isStrawActive, noEventSend)	
	ChopperSwitchEvent.sendEvent(self, isStrawActive, noEventSend);	
	self.isStrawActive = isStrawActive;
	self.isStrawSwitch = true;
	
	if self.isLoadingFromSaveGame then
		self.isLoadingFromSaveGame = false;
	end;
end;

function ChopperSwitcher:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local isStrawActive = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isStrawActive"), false);
		self.isLoadingFromSaveGame = true;
		self:setIsStrawActive(isStrawActive, true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ChopperSwitcher:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'isStrawActive="' .. tostring(self.isStrawActive) ..'"';
	return attributes, nil;
end;



--
-- ChopperSwitchEvent
-- Networkevent for ChopperSwitcher
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		14/11/12
-- @history:	v1.0 - Initial version
--
ChopperSwitchEvent = {};
ChopperSwitchEvent_mt = Class(ChopperSwitchEvent, Event);

InitEventClass(ChopperSwitchEvent, "ChopperSwitchEvent");

function ChopperSwitchEvent:emptyNew()
    local self = Event:new(ChopperSwitchEvent_mt);
    return self;
end;

function ChopperSwitchEvent:new(vehicle, isStrawActive)
    local self = ChopperSwitchEvent:emptyNew()
    self.vehicle = vehicle;
	self.isStrawActive = isStrawActive;
    return self;
end;

function ChopperSwitchEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isStrawActive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChopperSwitchEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isStrawActive);
end;

function ChopperSwitchEvent:run(connection)
	self.vehicle:setIsStrawActive(self.isStrawActive, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChopperSwitchEvent:new(self.vehicle, self.isStrawActive), nil, connection, self.vehicle);
	end;
end;

function ChopperSwitchEvent.sendEvent(vehicle, isStrawActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChopperSwitchEvent:new(vehicle, isStrawActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChopperSwitchEvent:new(vehicle, isStrawActive));
		end;
	end;
end;