--@author	 FIAT80-90DT
--@date		 05.01.2013
-- www.eifok-team.de
--
--		

StollR3354DS = {};

function StollR3354DS.prerequisitesPresent(specializations)
    return true;
end;
	
function StollR3354DS:load(xmlFile)
	self.animation.runOnTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#runOnTime"), 1) * 1000;
	self.animation.runOutTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#runOutTime"), 4) * 1000;
	self.animation.speed = 0;
	setAnimTrackSpeedScale(self.animation.animCharSet, 0, 0);
	
	-- replace windrower sound
	if self.isClient then
		local windrowerSound = getXMLString(xmlFile, "vehicle.windrower2Sound#file");
		if windrowerSound ~= nil and windrowerSound ~= "" then
			windrowerSound = Utils.getFilename(windrowerSound, self.baseDirectory);
			self.windrowerSound2 = createSample("windrower2Sound");
			self.windrowerSound2Enabled = false;
			loadSample(self.windrowerSound2, windrowerSound, false);
			self.windrowerSound2PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrower2Sound#pitchOffset"), 1);
			self.windrowerSound2Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrower2Sound#volume"), 1.0);
		end;
	end;	
	
	--#
	self.setSchwadtuch = SpecializationUtil.callSpecializationsFunction("setSchwadtuch");
	self.st = {};
	self.st.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.schwadtuch#node"));
	local x,y,z = getTranslation(self.st.node);
	self.st.origPos = {x, y, z};
	self.st.duration = Utils.getNoNil( getXMLFloat(xmlFile, "vehicle.schwadtuch#duration"), 1 )*1000;
	self.st.startX = getXMLFloat(xmlFile, "vehicle.schwadtuch#startX");
	self.st.endX = getXMLFloat(xmlFile, "vehicle.schwadtuch#endX");
	self.st.moveX = x;
	
end;

function StollR3354DS:postLoad(xmlFile)
end;

function StollR3354DS:delete()
	if self.windrowerSound2 ~= nil then
		delete(self.windrowerSound2);
	end;
end;

function StollR3354DS:readStream(streamId, connection)
	local mx = streamReadFloat32(streamId);
	self:setSchwadtuch(mx, true);
end;

function StollR3354DS:writeStream(streamId, connection)	
	streamWriteFloat32(streamId, self.st.moveX);
end;

function StollR3354DS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StollR3354DS:keyEvent(unicode, sym, modifier, isDown)
end;

function StollR3354DS:update(dt)
	
	if self.isClient and self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.StollR335_MORE) then
			local t = math.min( self.st.moveX + dt/self.st.duration, self.st.endX );
			if t ~= self.st.moveX then
				self:setSchwadtuch( t );
			end;
		elseif InputBinding.isPressed(InputBinding.StollR335_LESS) then
			local t = math.max( self.st.moveX - dt/self.st.duration, self.st.startX );
			if t ~= self.st.moveX then
				self:setSchwadtuch( t );
			end;
		end;
	end;
	
	--#
	if self.isClient then
		if self.isTurnedOn then
			if self.animation.speed < (self.animation.speedScale - 0.01) then
				local newSpeed = Utils.getMovedLimitedValues({self.animation.speed}, {self.animation.speedScale}, {0}, 1, self.animation.runOnTime, dt, false);
				self.animation.speed = newSpeed[1];
				setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animation.speed);
				setSamplePitch(self.windrowerSound2, self.windrowerSound2PitchOffset*self.animation.speed );
			end;
		else
			if self.animation.speed	> 0 then
				enableAnimTrack(self.animation.animCharSet, 0);
				local newSpeed = Utils.getMovedLimitedValues({self.animation.speed}, {self.animation.speedScale}, {0}, 1, self.animation.runOutTime, dt, true);
				self.animation.speed = newSpeed[1];
				setAnimTrackSpeedScale(self.animation.animCharSet, 0, newSpeed[1]);
				setSamplePitch(self.windrowerSound2, self.windrowerSound2PitchOffset*self.animation.speed );
				if self.animation.speed == 0 then
					disableAnimTrack(self.animation.animCharSet, 0);
				end;
			end;
		end;
	end;
	
	--#
	if self.isClient then
		if self:getIsActiveForSound() then
			if self.animationEnabled then
				if not self.windrowerSound2Enabled then
					playSample(self.windrowerSound2, 0, self.windrowerSound2Volume, 0);
					setSamplePitch(self.windrowerSound2, self.windrowerSound2PitchOffset);
					self.windrowerSound2Enabled = true;
				end;
			elseif self.animation.speed == 0 then
				if self.windrowerSound2Enabled then
					stopSample(self.windrowerSound2);
					self.windrowerSound2Enabled = false;
				end;			
			end;
		else 
			if self.windrowerSound2Enabled then
				stopSample(self.windrowerSound2);
				self.windrowerSound2Enabled = false;
			end;
		end;
	end;	
	
end;

function StollR3354DS:updateTick(dt)
end;

function StollR3354DS:setIsTurnedOn(isTurnedOn, noEventSend)
	--self.animationEnabled = true;
end;

function StollR3354DS:draw()
	g_currentMission:addExtraPrintText( string.format( g_i18n:getText("StollR335_TEXT"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollR335_MORE), InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollR335_LESS) ) );
end;

function StollR3354DS:setSchwadtuch(value, noEventSend)
	SetSchwadtuchEvent.sendEvent(self, value, noEventSend);
	self.st.moveX = value;
	setTranslation(self.st.node, self.st.moveX, self.st.origPos[2], self.st.origPos[3] );
end;


--
--
--
--
--
SetSchwadtuchEvent = {};
SetSchwadtuchEvent_mt = Class(SetSchwadtuchEvent, Event);

InitEventClass(SetSchwadtuchEvent, "SetSchwadtuchEvent");

function SetSchwadtuchEvent:emptyNew()
    local self = Event:new(SetSchwadtuchEvent_mt);
    self.className = "SetSchwadtuchEvent";
    return self;
end;

function SetSchwadtuchEvent:new(object, state)
    local self = SetSchwadtuchEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetSchwadtuchEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetSchwadtuchEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.state);
end;

function SetSchwadtuchEvent:run(connection)
	self.object:setSchwadtuch(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSchwadtuchEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetSchwadtuchEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetSchwadtuchEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetSchwadtuchEvent:new(vehicle, state));
		end;
	end;
end;


