-- ChangeAttJntMoveTime
-- changes the time to lift/lower the tool
--
-- by fruktor
-- www.eifok-team.de
-- 

ChangeAttJntMoveTime = {};

function ChangeAttJntMoveTime.prerequisitesPresent(specializations)
    return true;
end;
	
function ChangeAttJntMoveTime:load(xmlFile)	
	self.newMoveTime = getXMLFloat(xmlFile, "vehicle.attacherMoveTime#value"), 0.5;
	if self.newMoveTime ~= nil then
		self.newMoveTime = self.newMoveTime * 1000;
	end;
end;


function ChangeAttJntMoveTime:postLoad(xmlFile)

end;


function ChangeAttJntMoveTime:delete()

end;

function ChangeAttJntMoveTime:readStream(streamId, connection)
end;

function ChangeAttJntMoveTime:writeStream(streamId, connection)	
end;

function ChangeAttJntMoveTime:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChangeAttJntMoveTime:keyEvent(unicode, sym, modifier, isDown)

end;

function ChangeAttJntMoveTime:update(dt)
	if self.newMoveTime ~= nil then
		if self.doSearch == true then
			for k, implement in pairs(self.attVehicle.attachedImplements) do
				if implement.object == self then
					self.moveTimeBackUp = self.attVehicle.attacherJoints[implement.jointDescIndex].moveTime;
					self.attVehicle.attacherJoints[implement.jointDescIndex].moveTime = self.newMoveTime;
					break;
				end;
			end;
			self.doSearch = false;
		end
	end
end;

function ChangeAttJntMoveTime:updateTick(dt)

end;

function ChangeAttJntMoveTime:draw()
	
end;

function ChangeAttJntMoveTime:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ChangeAttJntMoveTime:getSaveAttributesAndNodes(nodeIdent)
end;

function ChangeAttJntMoveTime:onAttach(attacherVehicle)
	if self.newMoveTime ~= nil then
		self.attVehicle = attacherVehicle;
		self.doSearch = true;
	end
end;

function ChangeAttJntMoveTime:onDetach()
	if self.newMoveTime ~= nil then
		for k, implement in pairs(self.attVehicle.attachedImplements) do
			if implement.object == self then
				self.attVehicle.attacherJoints[implement.jointDescIndex].moveTime = self.moveTimeBackUp;
				break;
			end;
		end;
	end
end;

