--
-- Prosto
-- 
-- used to set 'control-variables' in cylinderd2
--
--
-- @author:		fruktor (wwww.modding-society.de)
-- @version:	v0.1
-- @date:		08/12/10
-- @history:	v0.1 - inital implementation
--
-- Copyright (C) 
--

Prosto = {};

function Prosto.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Prosto:load(xmlFile)

self.koleso = true

	self.GelenkF = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kolesowelle.GelenkF#index"));
    self.Welle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kolesowelle.Welle#index"));    
	self.RotPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kolesowelle.RotPoint#index"));

	self.doJointSearchCylindered = false;
	self.origMouseControlsAxes = self.mouseControlsAxes;
	self.disaMouseControlsAxes = {};
end;	
	

function Prosto:delete()
end;

function Prosto:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Prosto:keyEvent(unicode, sym, modifier, isDown)
end;

function Prosto:update(dt)
	   self.PointRot = getRotation(self.RotPoint)

       setRotation(self.GelenkF,self.PointRot ,0 ,0);
       setRotation(self.Welle,self.PointRot ,0 ,0);
end;

function Prosto:updateTick(dt)

	if self.varTip ~= nil then
		if self.varTip.activeTrailerIdx ~= self.varTip.trailerNr then
			self.mouseControlsAxes = self.disaMouseControlsAxes;
			return;
		else
			self.mouseControlsAxes = self.origMouseControlsAxes;
		end;
	end;

	-- ####
	if self.doJointSearchCylindered then
		if self.attacherVehicle ~= nil then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;
					self.doJointSearchCylindered = false;
					break;
				end;
			end;
		end;
		self.doJointSearchCylindered = false;
	end;
	
	-- #### update the attacherJoint!     
    if self.vehicleJoint ~= nil then
        setJointFrame(self.vehicleJoint.jointIndex, 1, self.attacherJoint.node);
	end;
	
	-- ### update PowerShaft!
	--[[
	if self.attacherVehiclePowerShaft ~= nil then
		self.doJointSearch = true;
	end;
	]]--	
end;

function Prosto:draw()
end;

function Prosto:onAttach()
	self.doJointSearchCylindered = true;
end;

function Prosto:onDetach()
	self.vehicleJoint = nil;
	
	local rX, rY, rZ = getRotation( Utils.indexToObject(self.components, "7|1") );
	
	if rX > Utils.degToRad(3) then
		self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILERLOW;
	else
		self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILER;
	end;
end;

function Prosto:onLeave()
end;

function Prosto:onDeactivate()
end;

function Prosto:onDeactivateSounds()
end;


