-- This Script is for the SMS Seeding Machine from VWFahrer80[www.ls-moddingwelt.eu]
-- author: Marvin P. (ihc-433[www.ls-moddingwelt.eu])
-- date: 20.04.11
-- Version: 1.0
--
-- Do not modify without my consent

SMS = {};

function SMS.prerequisitesPresent(specializations)
    return true;
end;

function SMS:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.Visibility = SpecializationUtil.callSpecializationsFunction("Visibility");
	
	
	self.Sperre = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Sperre#index"));
	self.VisTime = 4388;
	self.durationstart = 0;
	self.durationend = 5000;
	self.allowedVis = false;
	self.RpmActive = false;
	self.currentPos = 0;
	self.seeds = {FruitUtil.FRUITTYPE_GRASS};
	self.allowsSeedChanging = false;
	
	setVisibility(self.Sperre, false);
end;

function SMS:update(dt)

end;

function SMS:readStream(streamId, connection)
	self:Visibility(streamReadBool(streamId), true);
end;

function SMS:writeStream(streamId, connection)
	streamWriteBool(streamId, self.allowedVis);
end;

function SMS:updateTick(dt)	
	self.currentPos = getAnimTrackTime(self.foldingParts[1].animCharSet,0);
	if self:getIsActiveForInput () then
		self.currentPos = getAnimTrackTime(self.foldingParts[1].animCharSet,0);
		if self.currentPos < self.durationend and self.currentPos > self.durationstart then
			self.RpmActive = true;
			else
			self.RpmActive = false;
		end;
	end;
	if self.currentPos >= self.VisTime then
		self.allowedVis = true;
		else
		self.allowedVis = false;
	end;
	setVisibility(self.Sperre, self.allowedVis);
	self:setVehicleRpmUp(dt, self.RpmActive);
end;

function SMS:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function SMS:Visibility(new, noEventSend)
	VisibleEvent.sendEvent(self, new, noEventSend);
	self.allowedVis = new;
end;

function SMS:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;	
end;
function SMS:onDetach()
	if self.deactivateOnDetach then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function SMS:delete()
end;

function SMS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SMS:keyEvent(unicode, sym, modifier, isDown)
end;

function SMS:draw()
	if self.allowedVis then
		g_currentMission:addExtraPrintText(g_i18n:getText("transport"));
	end;
end;

function SMS:onLeave() 
end;