--
-- objectAttacherMBH
-- Specialization for attaching objects on a trailer
--
-- @author Geri-G
--
-- edited by PeterJ FS-UK modteam
-- 16/11/2012
--

objectAttacherMBH = {};

function objectAttacherMBH.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(AnimationHandler, specializations);
end;

function objectAttacherMBH:load(xmlFile)

	self.setIsBaleAttached = SpecializationUtil.callSpecializationsFunction("setIsBaleAttached");
	self.searchObjects = objectAttacherMBH.searchObjects;
	self.attachobjects = objectAttacherMBH.attachobjects;
	self.detachobjects = objectAttacherMBH.detachobjects;
	self.OrientJoint = objectAttacherMBH.OrientJoint;
	self.isObjectInRange = objectAttacherMBH.isObjectInRange;
	self.place = {};
	local i=0;
	while true do
		local basename = string.format("vehicle.baleCastPoints.baleCastPoint(%d)",i);
		local place = {};
		place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#frontRight"));

		if place.node1 == nil then
			break;
		end;
		place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#backLeft"));
		place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,basename.."#attacherNode"),"0>"));
		place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,basename.."#highOffset"),4);
		table.insert(self.place,place);
		i=i+1;
	end;
	self.allowVehicleAttachment = getXMLBool(xmlFile,"vehicle.baleCastPoints#allowVehicleAttachment");
	self.Attachedobjects = {};
	self.objectsAttached = false;
	self.isBaleAttach = false;	
end;

function objectAttacherMBH:delete()
end;

function objectAttacherMBH:readStream(streamId, connection)
	local baleAttach = streamReadBool(streamId);
	self:setIsBaleAttached(baleAttach, true);			
end;

function objectAttacherMBH:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isBaleAttach);
end;

function objectAttacherMBH:keyEvent(unicode, sym, modifier, isDown)
end;

function objectAttacherMBH:mouseEvent(posX, posY, isDown, isUp, button)
end;

function objectAttacherMBH:update(dt)
	if self:getIsActiveForInput() then

	end;
end;

function objectAttacherMBH:updateTick(dt)

	if self:getIsActive() and self.isServer then
		if self.animationParts[1].currentPosition > 1001 then
			if self.isBaleAttach == true then
				self:setIsBaleAttached(not self.isBaleAttach);
			end;
		end;
		if self.animationParts[1].currentPosition < 1001 then
			if self.isBaleAttach == false then
				self:setIsBaleAttached(not self.isBaleAttach);
			end;
		end;
	end;
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function objectAttacherMBH:draw()
	if self:getIsActive() then
	end;
end;

function objectAttacherMBH:isObjectInRange(place,object)
	local Xmax, Ymax, Zmax = getWorldTranslation(place.node1);
		  Xmax, Ymax, Zmax = worldToLocal(place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(place.node2);	
		  Xmin, Ymin, Zmin = worldToLocal(place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(object);
		  Xt, Yt, Zt = worldToLocal(place.attacherNode,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+place.highOffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;

function objectAttacherMBH:searchObjects()
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then 
			if item.item.isAttached == nil then--and (getUserAttribute(item.item.nodeId, "isHaybale") == true or getUserAttribute(item.item.nodeId, "isStrawbale") == true or getUserAttribute(item.item.nodeId, "isRoundbale") == true) then
				for k,v in pairs(self.place) do
					local isInRange = self:isObjectInRange(v,item.item.nodeId);			
					local is1stAttached = false;
					if isInRange then
						is1stAttached = self:attachobjects(v,item.item.nodeId,item.item);
					end;
					if is1stAttached then
						self.objectsAttached = true;
					end;
				end;
			end;
		end;
	end;
	if self.allowVehicleAttachment == true then
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle then
				local is1stAttached = false;
				for index,components in pairs(v.components) do		
					for k1,v1 in pairs(self.place) do
						local isInRange = self:isObjectInRange(v1,components.node);	
						if isInRange then	
							is1stAttached = self:attachobjects(v1,components.node);
						end;
					end;
				end;
				if is1stAttached then
					self.objectsAttached = true;
				end;
			end;
		end;
	end;
end;

function objectAttacherMBH:setIsBaleAttached(baleAttach, noEventSend)
	SetBaleAttachEvent.sendEvent(self, baleAttach, noEventSend)
	self.isBaleAttach = baleAttach;
	
	if baleAttach then
		self:detachobjects();	
	else
		self:searchObjects();
	end;
end;

function objectAttacherMBH:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function objectAttacherMBH:attachobjects(place,object,baleT)
	local attachedobject = {};
	attachedobject.object = object;
	if self.isServer then
		attachedobject.AT = createTransformGroup("AT");
		link(place.attacherNode,attachedobject.AT);
		
		self:OrientJoint(object,attachedobject.AT);

		local constr = JointConstructor:new();					
		constr:setActors(place.attacherNode, object);
		constr:setJointTransforms(attachedobject.AT,  object);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedobject.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects, attachedobject);
	return true;
end;

function objectAttacherMBH:detachobjects()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects = nil;
	self.Attachedobjects = {};
	self.objectsAttached = false;
end;

function objectAttacherMBH:onAttach(attacherVehicle)
	if self.isServer then
		self:setIsBaleAttached(false);
	end;
end;

function objectAttacherMBH:onDetach()
	if self.isServer then
		self:setIsBaleAttached(true);
	end;
end;
