-- NI Modding
--
-- author  	Henly20 
-- date  	03-12-2012.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com
--
Johnston = {}

function Johnston.prerequisitesPresent(specializations)
    return true;
end;

function Johnston:load(xmlFile)

	self.setChangeLadders = SpecializationUtil.callSpecializationsFunction("setChangeLadders");
	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;

	self.setArmTwo = SpecializationUtil.callSpecializationsFunction("setArmTwo");
	self.ArmTwoAnimation = getXMLString(xmlFile, "vehicle.armTwo#animationName");
	self.ArmTwo = false;
	
	self.ladder = {};
	self.ladder[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ladder#index1"));
	self.ladder[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ladder#index2"));
	self.ladder.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ladder#indexladder"));
	
	self.ladderMode = 0;	
	self.ladder1Active = true;
	self.ladder2Active = false;
	
end;
      
function Johnston:delete()
end;

function Johnston:readStream(streamId, connection)
	self:setChangeLadders(streamReadInt8(streamId), true);
    self:setArmOne(streamReadBool(streamId), true);
    self:setArmTwo(streamReadBool(streamId), true); 

end;

function Johnston:writeStream(streamId, connection)
   streamWriteInt8(streamId, self.ladders);	
   streamWriteBool(streamId, self.ArmOne);
   streamWriteBool(streamId, self.ArmTwo);

end;

function Johnston:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local ladderMode = Utils.getNoNil(getXMLInt(xmlFile, key.."#ladderMode"), 0);
		self:setChangeLadders(ladderMode);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Johnston:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'ladderMode="' .. tonumber(self.ladderMode) ..'"';	
	attributes = attributes .. mystring;

    local node = nil;
	return attributes, node;
end;


function Johnston:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Johnston:keyEvent(unicode, sym, modifier, isDown)
end;

function Johnston:update(dt)

	if not self:getIsActive() then


		if self.playerInRange then
		g_currentMission:addHelpButtonText(g_i18n:getText("LADDER"), InputBinding.IMPLEMENT_EXTRA3);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			if self.ladderMode > 2 then
				self.ladderMode = 0;
			end;
			self:setChangeLadders(math.abs(self.ladderMode + 1));
		end;
		end;
	end;
	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;	

end;

function Johnston:updateTick(dt)	
	if g_currentMission.player ~= nil then
		local nearestDistance = 3.0;
		local x1,y1,z1 = getWorldTranslation(self.ladder.node);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
end;

function Johnston:onLeave()
end;

function Johnston:draw()


end;

function Johnston:setChangeLadders(ladders, noEventSend)
	ChangeLadderEvent.sendEvent(self, ladders, noEventSend);

	self.ladderMode = ladders;

	if self.ladderMode == 0  then
		self.ladder1Active = true;
		self.ladder2Active = false;
		self:setArmOne(true);
		self:setArmTwo(true);
	end;
	if self.ladderMode == 1 then
		self.ladder1Active = false;
		self.ladder2Active = true;
		self:setArmOne(false);
		self:setArmTwo(true);
	end;
	if self.ladderMode == 2 then
		self.ladder1Active = false;
		self.ladder2Active = false;
		self:setArmOne(false);
		self:setArmTwo(false);
	end;
	if self.ladderMode == 3  then
		self.ladder1Active = true;
		self.ladder2Active = false;
		self:setArmOne(true);
		self:setArmTwo(true);
	end;
	
	if self.ladderMode > 2 then
		self.ladderMode = 0;
	end;
	
	setVisibility(self.ladder[1], self.ladder1Active);
	setVisibility(self.ladder[2], self.ladder2Active);

end;

function Johnston:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = true;
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;

function Johnston:setArmTwo(isArmTwo,noEventSend)
	SetArmTwoEvent.sendEvent(self, isArmTwo, noEventSend);
	-- Play ArmTwo animation --
	self.isArmTwoOn = isArmTwo;
	if self.isArmTwoOn then
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, -1, nil, true);
			self.ArmTwo = true;
		end;
	else
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, 1, nil, true);
			self.ArmTwo = false;
		end;
	end;	
end;


ChangeLadderEvent = {};
ChangeLadderEvent_mt = Class(ChangeLadderEvent, Event);

InitEventClass(ChangeLadderEvent, "ChangeLadderEvent");

function ChangeLadderEvent:emptyNew()
    local self = Event:new(ChangeLadderEvent_mt);
    self.className="ChangeLadderEvent";
    return self;
end;

function ChangeLadderEvent:new(object, ladders)
    local self = ChangeLadderEvent:emptyNew()
    self.object = object;
	self.ladders = ladders;
    return self;
end;

function ChangeLadderEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.ladders = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function ChangeLadderEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteInt8(streamId, self.ladders);	
end;

function ChangeLadderEvent:run(connection)
	self.object:setChangeLadders(self.ladders, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChangeLadderEvent:new(self.object, self.ladders), nil, connection, self.object);
	end;
end;

function ChangeLadderEvent.sendEvent(object, ladders, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeLadderEvent:new(object, ladders), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(ChangeLadderEvent:new(object, ladders));
		end;
	end;
end;

SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(object, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.object = object;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	if self.object ~= nil then
		self.object:setArmOne(self.isArmOne, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.object, self.isArmOne), nil, connection, self.object);
    end;
end;

function SetArmOneEvent.sendEvent(object, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(object, isArmOne), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(object, isArmOne));
		end;
	end;
end;

SetArmTwoEvent = {};
SetArmTwoEvent_mt = Class(SetArmTwoEvent, Event);

InitEventClass(SetArmTwoEvent, "SetArmTwoEvent");

function SetArmTwoEvent:emptyNew()
    local self = Event:new(SetArmTwoEvent_mt);
    self.className="SetArmTwoEvent";
    return self;
end;

function SetArmTwoEvent:new(object, isArmTwo)
    local self = SetArmTwoEvent:emptyNew()
    self.object = object;
	self.isArmTwo = isArmTwo;
    return self;
end;

function SetArmTwoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmTwo = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetArmTwoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isArmTwo);
end;

function SetArmTwoEvent:run(connection)   
	if self.object ~= nil then
		self.object:setArmTwo(self.isArmTwo, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmTwoEvent:new(self.object, self.isArmTwo), nil, connection, self.object);
    end;
end;

function SetArmTwoEvent.sendEvent(object, isArmTwo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmTwoEvent:new(object, isArmTwo), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(SetArmTwoEvent:new(object, isArmTwo));
		end;
	end;
end;
