-- NI Modding
--
-- author  	Henly20 
-- date  	03-11-2012.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com

FlemingBH = {};

function FlemingBH.prerequisitesPresent(specializations)
    return true;
end;

function FlemingBH:load(xmlFile)

	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;

end;

function FlemingBH:readStream(streamId, connection)
	self:setArmOne(streamReadBool(streamId), true);
	
end;

function FlemingBH:delete()
end;

function FlemingBH:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FlemingBH:keyEvent(unicode, sym, modifier, isDown)
end;

function FlemingBH:writeStream(streamId, connection)

	streamWriteBool(streamId, self.ArmOne);
end;

function FlemingBH:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setArmOne(not self.isArmOneOn);
		end;
	end;
end;

function FlemingBH:updateTick(dt)
end;

function FlemingBH:draw()

	if self:getIsActive() then
		if self.ArmOne == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("Open"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Close"), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;
end;

function FlemingBH:onAttach(attacherVehicle)
end;

function FlemingBH:onDetach()

	if self.isServer then
		self:setArmOne(false);
	end;
end;

function FlemingBH:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = true;
			self:setIsBaleAttached(true);
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;
