--
-- SDF
-- Specialization class for SDF group

-- @Authors of original scripts used: Manuel Leithner (SFM-Modding),Modelleicher (www.schwabenmodding.bplaced.net),Templaer, JoXXer, Knagsted, Mofa-Killer, Face, Heady, other do not remember!!
-- @author  Ago-Systemtech (https://www.facebook.com/ago.systemtech)(http://www.modhoster.de/)
-- @date 25/07/2013
-- free for noncommerical-usage ----

SDFBase = {};

function SDFBase.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SDFBase:load(xmlFile)
    ---------------------CAM INTERNA MOBILE---------------------
	self.internalCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.internalCamera#index"));
	self.camPositionX = 0;
	self.camPositionZ = 0;
	self.camPositionY = 0;
	
		
	self.ledriserva = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.riserva = 100;
	self.prevousFuelPercentage = 0;

		
	 -------------------------AllradV4-----------------	
	self.allradState = SpecializationUtil.callSpecializationsFunction("allradState");
    self.AllradV41Active = true;
	 
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
    self.hudAllradPosX = 0.491;
    self.hudAllradPosY = 0.0910;
    self.hudAllradWidth = 0.267;
    self.hudAllradHeight = 0.038;
	
	self.infoPanelAllradONPath = Utils.getFilename("textur/allrad_symb_yes.png", self.baseDirectory);
	self.hudAllradONOverlay = Overlay:new("textur/allrad_symb_yes", self.infoPanelAllradONPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);
	self.infoPanelAllradOFFPath = Utils.getFilename("textur/allrad_symb_no.png", self.baseDirectory);
	self.hudAllradOFFOverlay = Overlay:new("textur/allrad_symb_no", self.infoPanelAllradOFFPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);
	
	self.showhudAllrad = false;

---------------------HANDBRAKE---------------------
	self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
	self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
	self.handBrakeHud = Overlay:new("HandbrakeOverlay", Utils.getFilename("Textur/handbrake.dds", self.baseDirectory), 0.860, 0.184, 0.1726, 0.039525); -- 0.080, 0.085
	self.handbrake = true;
	handbrakeSoundFile = Utils.getFilename("sound/handbrake.ogg", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	brakeSoundFile = Utils.getFilename("sound/compressedAir.ogg", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	brakereleaseSoundFile = Utils.getFilename("sound/brake.ogg", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
	self.brakereleasePlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;
    self.HandBrakeTurnOff = false;

	
	
	------------------- Varibles for lowering front+back--------------------------------
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
	
	
	   ----led---
	self.batteriaicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.batteriaicona#index")); 
	self.olioicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.olioicona#index")); 
	self.tachiicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachiicona#index"));
    self.pcicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pcicona#index"));
    self.PTOPulsante = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOPulsante#index"));
	self.PTOLed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOLed#index"));	
	self.led4WDon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Led4WDon#index"));
    self.led4WDoff = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Led4WDoff#index"));	
	self.led4WDoff2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Led4WDoff2#index")); 
	   -- Leve ---
	self.levaindicatori = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.levaindicatori#index"));
	self.wiperLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperLever#index"));
	
	
	--Hydraulic--
    self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));

      ---------------Parafanghi------------------
	self.fender = {};
	self.fender.leftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#leftIndex"));
	self.fender.rightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#rightIndex"));
	self.fender.leftRotMax = getXMLInt(xmlFile, "vehicle.fender#leftRotMax");
	self.fender.rightRotMax = getXMLInt(xmlFile, "vehicle.fender#rightRotMax");
	
	---------WheelStering---------------- 	
	self.updateInterval = 0;
	self.steeringWheels = {};
	if table.getn(self.wheels) > 0 then
		local numSteeringWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.steeringWheels#count"), 0);
		for i=1, numSteeringWheels do
			local wheelnamei = string.format("vehicle.steeringWheels.wheel" .. "%d", i);
			local wheelNumber = getXMLInt(xmlFile, wheelnamei.."#wheelNumber");
			if wheelNumber ~= 0 and wheelNumber ~= nil and self.wheels[wheelNumber] ~= nil then
				local entry = {};
				entry.wheelNumber = wheelNumber;
				local maxFallRotation = unpack(Utils.getRadiansFromString(getXMLString(xmlFile, wheelnamei.."#maxFallRotation"), 1));
				entry.factor = maxFallRotation/self.wheels[wheelNumber].rotMax;
				self.steeringWheels[i] = entry;
			end;
		end;
	end;
	 
    
    ------------------ Rotazioni indicatori---------------------		
   
	local rotationPartNodeContagiri = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartContagiri#index"));
    if rotationPartNodeContagiri ~= nil then
        self.rotationPartContagiri = {};
        self.rotationPartContagiri.node = rotationPartNodeContagiri;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartContagiri#minRot"));
        self.rotationPartContagiri.minRot = {};
        self.rotationPartContagiri.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartContagiri.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartContagiri.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartContagiri#maxRot"));
        self.rotationPartContagiri.maxRot = {};
        self.rotationPartContagiri.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartContagiri.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartContagiri.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartContagiri.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartContagiri#rotTime"), 2)*1000;
        self.rotationPartContagiri.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartContagiri#touchRotLimit"), 10));
    end;
	
		
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
		
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;

	
	

	-----------------sound riserva------------------
	fuelwarningSoundFile = Utils.getFilename("sound/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function SDFBase:stopMotor()
   			if self.isWiperFrontActive then
			disableAnimTrack(self.wiperFrontAnimCharSet, 0);
			end;
			if self.isWiperBackActive then
			disableAnimTrack(self.wiperBackAnimCharSet, 0);
			end;
	
end;

function SDFBase:delete()
     if self.hudAllradONOverlay ~= nil or self.hudAllradOFFOverlay ~= nil then
		self.hudAllradONOverlay:delete();
		self.hudAllradOFFOverlay:delete();		
	end;
end;
function SDFBase:readStream(streamId, connection)
       self:allradState(streamReadBool(streamId), true);
end;

function SDFBase:writeStream(streamId, connection)
	streamWriteBool(streamId, self.AllradV41Active); 
end;

function SDFBase:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		if streamReadBool(streamId) then
		end;
	end;
end;

function SDFBase:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if streamWriteBool(streamId, bitAND(dirtyMask, self.vehicleDirtyFlag) ~= 0) then
        end;
    end;
end;
function SDFBase:mouseEvent(posX, posY, isDown, isUp, button)

end;

function SDFBase:keyEvent(unicode, sym, modifier, isDown)
	-------------------------HANDBRAKE---------------------------
	if isDown and sym == Input.KEY_y then
        self:setHandBrakeState(not self.handbrake);
		if self.handbrake and self:getIsActiveForSound() then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;
	
	
	
	
end;

function SDFBase:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.AllradV41Active = state;
end;


function SDFBase:update(dt)
	
    if self:getIsActive() then
		Cylindered.updateMovingPart(self, self.movingParts[1]);
        
        if self.backHydraulic ~= nil then
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);
		end;
        
       for _, part in pairs(self.movingParts) do
		   part.isDirty = true;
	   end;
        
        local sx,sy,sz = getTranslation(self.sitz);
        local _,ry,_ = getTranslation(self.wheels[1].repr);
        setTranslation(self.sitz, sx, (ry+2.0895) /3, sz);  
		
        -----------------parafanghi----------------		
		local x1,y1,z1 = getRotation(self.wheels[1].repr);
		if y1 < math.rad(self.fender.rightRotMax) then
			setRotation(self.fender.rightNode, 0, math.rad(7), 0);
		else
			setRotation(self.fender.rightNode, 0, 0, 0);
		end;
		
		local x2,y2,z2 = getRotation(self.wheels[2].repr);
		if y2 > math.rad(self.fender.leftRotMax) then
			setRotation(self.fender.leftNode, 0, math.rad(-7), 0);
		else
			setRotation(self.fender.leftNode, 0, 0, 0);
		end;
		
     	---------------------Lampeggianti---------------
        for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;

	end;
           			

	
    -------------- Indication ----------------------------------
	if self.isMotorStarted then
		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;

	else
	setRotation(self.rotationPartTanknadel.node, 0, 75 , 0);
	end;
	
		
  local maxContagiri = 2500;
  if self.isMotorStarted then
	if self.rotationPartContagiri ~= nil then
		local x, y, z = getRotation(self.rotationPartContagiri.node);
		y = ((self.rotationPartContagiri.maxRot[2] - self.rotationPartContagiri.minRot[2]) / maxContagiri) * self.motor.lastMotorRpm + self.rotationPartContagiri.minRot[2];
		setRotation(self.rotationPartContagiri.node, x, y ,z);
	end;
	else
	setRotation(self.rotationPartContagiri.node, 0, 0 , 0);
	end;
		
	local maxKmh = 50;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;

	
	if self.isEntered then
		if self.fuelFillLevel < 50 then
			self.riserva = self.riserva - dt;
			if self.riserva <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.riserva = 30000;
			end;
			self.ledriservaActive = true;
		else
			self.riserva = 30000;
			self.ledriservaActive = false;
		end;
		setVisibility(self.ledriserva,self.ledriservaActive);
	end;

	
		
	
	    
		 ----------------------HANDBRAKE--------------------
		if self:getIsActive() then
		if Input.isKeyPressed(Input.KEY_s) then
				if not self.braking then
					self.braking = true;
				end;
				if not self.brakePlaying and self:getIsActiveForSound() then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;
		else
			self.brakePlaying = false;
			self.braking = false;
			if not self.brakereleasePlaying and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;
	end;
	
		---------------------CAM INTERNA MOBILE---------------------	
	 if self.camIndex == 1 then
	if self:getIsActive() then
		
		if InputBinding.isPressed(InputBinding.MOVECAMLEFT) then
			self.camPositionX = self.camPositionX + 0.03;
			if self.camPositionX >= 0.3 then
				self.camPositionX = 0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMRIGHT) then
			self.camPositionX = self.camPositionX - 0.03;
			if self.camPositionX <= -0.3 then
				self.camPositionX = -0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMFORWARD) then
			self.camPositionY = self.camPositionY + 0.03;
			if self.camPositionY >= 0.31 then
				self.camPositionY = 0.31;
			end;
		end;
				if InputBinding.isPressed(InputBinding.MOVECAMBACK) then
			self.camPositionY = self.camPositionY - 0.03;
			if self.camPositionY <= -0.3 then
				self.camPositionY = -0.3;
			end;
		end;
		
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
			self.camPositionZ = self.camPositionZ + 0.03;
			if self.camPositionZ >= 0.16 then
				self.camPositionZ = 0.16;
			end;
		end;
		
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
			self.camPositionZ = self.camPositionZ - 0.03;
			if self.camPositionZ <= -0.16 then
				self.camPositionZ = -0.16;
			end;
		end;
		
	
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
			self.camPositionX = 0;
			self.camPositionZ = 0;
			self.camPositionY = 0;
		end;
		
		if self.internalCamera ~= nil then
			setTranslation(self.internalCamera, self.camPositionX, self.camPositionZ, self.camPositionY);
		end;
   	end;
	end;
	
	
	------------------AllRad v.4---------------------------
	 if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		if InputBinding.hasEvent(InputBinding.AllradV41) then
		  self:allradState(not self.AllradV41Active);
		end;
    end;	
	if self:getIsActive() then	
   		if self.AllradV41Active == true then
		    self.showhudAllrad = true;	
			setVisibility(self.led4WDon, true);
            setVisibility(self.led4WDoff, false);
            setVisibility(self.led4WDoff2, false);			
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudAllrad = false;
			setVisibility(self.led4WDon, false);
			setVisibility(self.led4WDoff, true);
			setVisibility(self.led4WDoff2, true);
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
    end;
	---------------WheelStering----------------
	if not self.startedUpdating then
		self.updateInterval = self.time+10;
		self.startedUpdating = true;
	end;
	if self:getIsActive() and self.updateInterval <= self.time then
		for k, wheel in pairs(self.wheels) do
			for c, steeringWheel in pairs(self.steeringWheels) do
				if k == steeringWheel.wheelNumber then
					local steeringAngle = wheel.steeringAngle;			
					local x,y,z = getRotation(wheel.repr);
					local xDrive,yDrive,zDrive;
					if wheel.repr == wheel.driveNode then
						xDrive,yDrive,zDrive = x,y,z;
					else
						xDrive,yDrive,zDrive = getRotation(wheel.driveNode);
					end;						
					local zFallRotation = -(steeringAngle*steeringWheel.factor);
					
					if wheel.repr == wheel.driveNode then
						setRotation(wheel.repr, xDrive, steeringAngle, zFallRotation);
					else
						setRotation(wheel.repr, x, steeringAngle, zFallRotation);
						setRotation(wheel.driveNode, xDrive, yDrive, zDrive);
					end;
				end;
			end;
			
		end;
		self.updateInterval = self.time+10;
	end;
		    
	   
end;

function SDFBase:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function SDFBase:updateTick(dt)

    if self:getIsActive() then	
					
			
		if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.tachiicona, true);
			setVisibility(self.pcicona, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.tachiicona, false);
			setVisibility(self.pcicona, false);
		end;
		
		for k, implement in pairs(self.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn then
						setTranslation(self.PTOPulsante, -0.47269, 1.94494, -0.61653);
						setVisibility(self.PTOLed, true);
					else
						setTranslation(self.PTOPulsante, -0.47233, 1.9463, -0.61646);
						setVisibility(self.PTOLed, false);
					end;
				end;
			end;
			

		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
				
	
	

	if self.handbrakelight ~= nil then
		if self.handbrake then
			setVisibility(self.handbrakelight, true);
		else
			setVisibility(self.handbrakelight, false);
		end;
	end

	-------------------HANDBRAKE-----------------
	 	if self.isServer then
        if self.handbrake then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, 0);
                end;
            end;
        elseif not self.handbrake and self.HandBrakeTurnOff then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, 0);
                end;
            end;
            self.HandBrakeTurnOff = false;
        end;
    end;
	
end;

function SDFBase:setHandBrakeState(state, noEventSend)
HandbrakeEvent.sendEvent(self, state, noEventSend); -- MP Fix by modelleicher, addet Event
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
    setVisibility(self.handbrakelight, state);
end;

function SDFBase:draw()
      


	if self.isEntered then
		if not self.helpPanel then
			--renderText(0.72, 0.25, 0.02, "Tasto m: Info On");
		else
			--renderText(0.72, 0.25, 0.02, "Tasto m: Info Off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.56, 0.023, "      - Help -   ");
			renderText(0.02, 0.54, 0.021, "Prima di agganciare un rimorchio regolare l'altezza del gancio");
			renderText(0.02, 0.52, 0.021, "Before attaching a trailer to adjust the height of the hook");
			renderText(0.02, 0.50, 0.021, "Vor dem Anbringen eines Anhangers, die Hohe des Hakens.");
			renderText(0.02, 0.48, 0.021, "      ---------------------------------");
			renderText(0.02, 0.46, 0.021, "Il trattore lavabile e si sporca dopo circa DUE ORE di gioco.");
			renderText(0.02, 0.44, 0.021, "Si puo lavare e si pulisce anche con la pioggia.");
			renderText(0.02, 0.42, 0.021, "The tractor is washable and it gets dirty after about two hours of play.");
			renderText(0.02, 0.40, 0.021, "You can wash and clean even with the rain.");
			renderText(0.02, 0.38, 0.021, "Der Traktor ist waschbar und es wird schmutzig nach etwa zwei Stunden zu spielen.");
			renderText(0.02, 0.36, 0.021, "Sie konnen waschen und zu reinigen, auch mit dem regen.");
			renderText(0.02, 0.34, 0.021, "      ---------------------------------");
			renderText(0.02, 0.32, 0.021, "Per usare il limitatore di giri ESLimiter, premere i tasti Pgup/Pgdown");
			renderText(0.02, 0.30, 0.021, "To use the rev limiter ESLimiter, press the PgUp / PgDown");
			renderText(0.02, 0.28, 0.021, "Zur Verwendung der Drehzahlbegrenzer ESLimiter, drucken Sie die Bild auf / Bild ab");
			renderText(0.02, 0.26, 0.021, "      ---------------------------------");
			renderText(0.02, 0.24, 0.021, "Grazie per aver scelto una mia mod-Thank you for my mod-Vielen Dank fur meine mod");
			renderText(0.02, 0.22, 0.021, "Support, TRACTOR ITALIA FORUM: http://forum.tractor-italia.net");
			renderText(0.02, 0.20, 0.021, "ATTENZIONE VIETATO FARE MODIFICHE-ATTENTION, FORBIDDEN TO DO CHANGES.");
			renderText(0.02, 0.18, 0.021, "Creative Commons license, by Ago-Systemtech");
		end;
	end;
	
	if self.isEntered then
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				self.handBrakeHud:render();
			end;
		self.handBrakeHud:render();
		end;
	end;
	if self.isEntered then
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
	if self.isEntered then
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_s) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
	if self.showhudAllrad == true then
      	self.hudAllradONOverlay:render();
		g_currentMission:addHelpButtonText(g_i18n:getText("AllradOFF"), InputBinding.AllradV41);	
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("AllradON"), InputBinding.AllradV41);		
	    self.hudAllradOFFOverlay:render();
   end;
   

end;


function SDFBase:attachImplement(implement)

	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 2 then
			setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, true);
		end;
	end;
	
	
	self.updateJoint = true;
end;
function SDFBase:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if jointIndex == 2 then
		setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, false);
	end;
	
end;

function SDFBase:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end

function SDFBase:onEnter()
        if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.tachiicona, true);
			setVisibility(self.pcicona, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.tachiicona, false);
			setVisibility(self.pcicona, false);
		end
		
	
	
	
end;
function SDFBase:onLeave()
        		 
	if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.tachiicona, true);
			setVisibility(self.pcicona, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.tachiicona, false);
			setVisibility(self.pcicona, false);
		end


	    
end;

-- HANDBRAKE EVENT --
-- MP Fix by modelleicher
HandbrakeEvent = {};
HandbrakeEvent_mt = Class(HandbrakeEvent, Event);

InitEventClass(HandbrakeEvent, "HandbrakeEvent");

function HandbrakeEvent:emptyNew()
    local self = Event:new(HandbrakeEvent_mt);
    self.className = "HandbrakeEvent";
    return self;
end;

function HandbrakeEvent:new(object, state)
    local self = HandbrakeEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function HandbrakeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function HandbrakeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function HandbrakeEvent:run(connection)
    self.object:setHandBrakeState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(HandbrakeEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function HandbrakeEvent.sendEvent(vehicle, state, noEventSend)
    if state ~= vehicle.handbrake then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(HandbrakeEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(HandbrakeEvent:new(vehicle, state));
            end;
        end;
    end;
end;
