
Assale = {}

function Assale.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Assale:load(xmlFile)
		-- Front axle animation
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));

end;
      
function Assale:delete()
end;

function Assale:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Assale:keyEvent(unicode, sym, modifier, isDown)
end;

function Assale:update(dt)
    if self:getIsActive() then
		if self.isMotorStarted then
			self.engineRunTime = dt + self.engineRunTime;
		else
			self.engineRunTime = 0;
		end;
		
		-- Front axle animation
					
	  if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local ax, ay, az = getWorldTranslation(self.wheels[2].repr);
        local bx, by, bz = getWorldTranslation(self.wheels[1].repr);
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.rotNode), bx-ax, by-ay, bz-az);
		
        setDirection(self.frontAxle.rotNode, x, y, z, 1, 0, 1);
		
		local x2,y2,z2 = getRotation(self.frontAxle.rotNode);
	
		setRotation(self.frontAxle.rotNode,x2 - 1.571,y2,z2 + 1.571);
	  end;
	end;	
end;


function Assale:onLeave()
end;

function Assale:draw()
	
end;
