
--
-- @author  PeterJ - euroDZN
-- @date  18/04/2014
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.


RichardWestern = {}

function RichardWestern.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function RichardWestern:load(xmlFile)

	self.setChangeLadders = SpecializationUtil.callSpecializationsFunction("setChangeLadders");
	self.laddersAnimation = getXMLString(xmlFile, "vehicle.ladders#animationName");
	self.isLaddersOn = true;
	self.ladderNode = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ladders#index"));
	self.ladderRange = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ladders#rangeIndex"));
	
    self.beaconLightsRot = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.beaconLights.beaconLight(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#rotPart"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.02);
        if node ~= nil then
            table.insert(self.beaconLightsRot, {node=node, speed=speed});
        end;
        i = i + 1;
    end;
	
end;

function RichardWestern:delete()
end;

function RichardWestern:readStream(streamId, connection)
    self:setChangeLadders(streamReadBool(streamId), true);
end;

function RichardWestern:writeStream(streamId, connection)
   streamWriteBool(streamId, self.isLaddersOn);
end;

function RichardWestern:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local laddersOn = getXMLBool(xmlFile, key.."#laddersOn");
		if laddersOn ~= nil and not laddersOn then
			self:setChangeLadders(laddersOn);
			RichardWestern.setAnimTime(self, 1);
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function RichardWestern:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'laddersOn="'..tostring(self.isLaddersOn)..'"';
	return attributes, nil;
end;

function RichardWestern:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RichardWestern:keyEvent(unicode, sym, modifier, isDown)
end;

function RichardWestern:update(dt)

	if not self:getIsActive() then
		if self.playerInRange then
			g_currentMission:addHelpButtonText(g_i18n:getText("LADDER"), InputBinding.IMPLEMENT_EXTRA3);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self:setChangeLadders(not self.isLaddersOn);
			end;
		end;
	end;

	if self.beaconLightsActive then
		for _, beaconLightRot in pairs(self.beaconLightsRot) do
		rotate(beaconLightRot.node, 0, beaconLightRot.speed*dt, 0);
		end;
	end;
end;

function RichardWestern:updateTick(dt)	
	if g_currentMission.player ~= nil then
		local nearestDistance = 3.2;
		local x1,y1,z1 = getWorldTranslation(self.ladderRange);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
end;

function RichardWestern:draw()
end;

function RichardWestern:setChangeLadders(isLaddersOn, noEventSend)
	SetLaddersEvent.sendEvent(self, isLaddersOn, noEventSend);

	if self.isLaddersOn ~= isLaddersOn then
		if self.isLaddersOn then
			if self.laddersAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.laddersAnimation, 1, nil, true);
			end;
		else
			if self.laddersAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.laddersAnimation, -1, nil, true);
			end;
		end;
		setVisibility(self.ladderNode, isLaddersOn);
		self.isLaddersOn = isLaddersOn;
	end;
end;

function RichardWestern.setAnimTime(self, animTime)
	if self.playAnimation ~= nil then
		local animDuration = self:getAnimationDuration(self.laddersAnimation)
		local stopAnimTime = (animTime*animDuration)/animDuration;
		self:playAnimation(self.laddersAnimation, 1, nil, true);
		self:setAnimationStopTime(self.laddersAnimation, stopAnimTime);
		AnimatedVehicle.updateAnimationByName(self, self.laddersAnimation, 99999999);
	end;
	if self.updateCylinderedInitial ~= nil then
		self:updateCylinderedInitial();
	end;
end;

SetLaddersEvent = {};
SetLaddersEvent_mt = Class(SetLaddersEvent, Event);

InitEventClass(SetLaddersEvent, "SetLaddersEvent");

function SetLaddersEvent:emptyNew()
    local self = Event:new(SetLaddersEvent_mt);
    self.className="SetLaddersEvent";
    return self;
end;

function SetLaddersEvent:new(object, isLaddersOn)
    local self = SetLaddersEvent:emptyNew()
    self.object = object;
	self.isLaddersOn = isLaddersOn;
    return self;
end;

function SetLaddersEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLaddersOn = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetLaddersEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isLaddersOn);
end;

function SetLaddersEvent:run(connection)   
	if self.object ~= nil then
		self.object:setChangeLadders(self.isLaddersOn, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLaddersEvent:new(self.object, self.isLaddersOn), nil, connection, self.object);
    end;
end;

function SetLaddersEvent.sendEvent(object, isLaddersOn, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLaddersEvent:new(object, isLaddersOn), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(SetLaddersEvent:new(object, isLaddersOn));
		end;
	end;
end;
