--
-- BaleCounter
-- Specialization for baler to display a bale counter.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--
-- edited by LS-UK modteam
-- @ 25/06/2011

BaleCounter = {};

function BaleCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function BaleCounter:load(xmlFile)
	self.SetBaleCount= SpecializationUtil.callSpecializationsFunction("SetBaleCount");
	--  HUD --
	self.File = Utils.getFilename("textures/counter.png", self.baseDirectory);
	self.hudPoxX = 0.495;
	self.hudPoxY = 0.84; 
	self.hudWidth = 0.2;
	self.hudHeight = 0.15;
	self.HUDMCHALE = Overlay:new("HUDMCHALE", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
	self.HUD = false;
	
	self.TotalMcHaleBalesCount = 0;
	self.CurrentMcHaleBalesCount = 0;

end;

function BaleCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local TotalMcHaleBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#TotalMcHaleBalesCount"),0);
	self.TotalMcHaleBalesCount = TotalMcHaleBalesCount;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function BaleCounter:getSaveAttributesAndNodes(nodeIdent)
	local TotalMcHaleBalesCount= Utils.getNoNil(self.TotalMcHaleBalesCount, 0);
	local attributes = 'TotalMcHaleBalesCount="'..string.format("%.1f",TotalMcHaleBalesCount)..'"';
	return attributes, nil;
end;

function BaleCounter:delete()
end;

function BaleCounter:readStream(streamId, connection)
	self.TotalMcHaleBalesCount = streamReadInt32(streamId);
	self.CurrentMcHaleBalesCount = streamReadInt32(streamId);
end;

function BaleCounter:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.TotalMcHaleBalesCount);
	streamWriteInt32(streamId, self.CurrentMcHaleBalesCount);
end;

function BaleCounter:readUpdateStream(streamId, timestamp, connection)
end;

function BaleCounter:writeUpdateStream(streamId, connection, dirtyMask)
end;

function BaleCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BaleCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function BaleCounter:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENTHUD) then
			self.HUD = not self.HUD;
		end;
    end;
end;

function BaleCounter:updateTick(dt)	
end;

function BaleCounter:draw()
	setTextBold(true);
	setTextColor(0, 0, 0, 1.0);
	if self.HUD then
		self.HUDMCHALE:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.IMPLEMENTHUD);
		if self.CurrentMcHaleBalesCount~= nil then
			renderText(0.595, 0.942, 0.020, string.format(self.CurrentMcHaleBalesCount));
		end;
		if self.TotalMcHaleBalesCount~= nil then
			renderText(0.595, 0.901, 0.020, string.format(self.TotalMcHaleBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.IMPLEMENTHUD);	
	end;
end;

function BaleCounter.dropBale(self, baleIndex)
	if self.CurrentMcHaleBalesCount ~= nil and self.TotalMcHaleBalesCount ~= nil then
		self.CurrentMcHaleBalesCount = self.CurrentMcHaleBalesCount +1;
		self.TotalMcHaleBalesCount = self.TotalMcHaleBalesCount +1;
	end;
end;

Baler.dropBale = Utils.appendedFunction(Baler.dropBale, BaleCounter.dropBale);