--
-- Roue
-- Specialization for change steering mode
--
-- @author:  	?
-- @edit:  		Burner
-- @date:		12.03.2012
-- 

Roue = {};

function Roue.prerequisitesPresent(specializations)
    return true;
end;

function Roue:load(xmlFile)
    self.changeSteer = SpecializationUtil.callSpecializationsFunction("changeSteer");
	self.changeSteeringMode = SpecializationUtil.callSpecializationsFunction("changeSteeringMode");
	self.changeWheel = 0;
	self.drivingDir = 1;
	self.changeWheelNames = {}
	self.changeWheelNames[0] = g_i18n:getText("frontAxleSteering");
	self.changeWheelNames[1] = g_i18n:getText("rearAxleSteering");
	self.changeWheelNames[2] = g_i18n:getText("bothAxleSteering");
	self.changeWheelNames[3] = g_i18n:getText("crabSteering");
end;

function Roue:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Roue:keyEvent(unicode, sym, modifier, isDown)
end;

function Roue:update(dt)
	if self.animationParts[1].currentPosition < 5600 and self.animationParts[1].currentPosition > 1600 then
		if InputBinding.hasEvent(InputBinding.NawaroMaus_SteeringMode) and self:getIsActiveForInput() then
			self:changeSteeringMode();
		end;
	else
		self.changeWheel = 0
	end;

	if self.changeWheel == 0  then
		self:changeSteer(34, -34, 55*self.drivingDir, 34, -34, 55*self.drivingDir, 0, 0, 0, 0, 0, 0)
	elseif self.changeWheel == 1 then
		self:changeSteer(0, 0, 0, 0, 0, 0, 34, -34, -55*self.drivingDir, 34, -34, -55*self.drivingDir)
	elseif self.changeWheel == 2 then
		self:changeSteer(34, -34, 55*self.drivingDir, 34, -34, 55*self.drivingDir, 34, -34, -55*self.drivingDir, 34, -34, -55*self.drivingDir)
	elseif self.changeWheel == 3 then
		self:changeSteer(34, -34, 55*self.drivingDir, 34, -34, 55*self.drivingDir, 34, -34, 55*self.drivingDir, 34, -34, 55*self.drivingDir)
	elseif self.changeWheel == 4 then
		self.changeWheel = 0;
	end;
end;

function Roue:readStream(streamId, connection)
	self.changeWheel = streamReadInt8(streamId);
end;

function Roue:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.changeWheel);
end;

function Roue:draw()
end;

function Roue:changeSteeringMode()
	self.changeWheel = self.changeWheel +1 ;
	RoueEvent.sendEvent(self, self.changeWheel);
end;

function Roue:changeSteer(wheel1min, wheel1max, wheel1speed, wheel2min, wheel2max, wheel2speed, wheel3min, wheel3max, wheel3speed, wheel4min, wheel4max, wheel4speed)
    self.wheels[1].rotMax = Utils.degToRad(wheel1min);
    self.wheels[2].rotMax = Utils.degToRad(wheel2min);
    self.wheels[1].rotMin = Utils.degToRad(wheel1max);
    self.wheels[2].rotMin = Utils.degToRad(wheel2max);   
    self.wheels[3].rotMax = Utils.degToRad(wheel3min);
    self.wheels[4].rotMax = Utils.degToRad(wheel4min);
    self.wheels[3].rotMin = Utils.degToRad(wheel3max);
    self.wheels[4].rotMin = Utils.degToRad(wheel4max);  
    self.wheels[1].rotSpeed = Utils.degToRad(wheel1speed); 
    self.wheels[2].rotSpeed = Utils.degToRad(wheel2speed);
    self.wheels[3].rotSpeed = Utils.degToRad(wheel3speed); 
    self.wheels[4].rotSpeed = Utils.degToRad(wheel4speed);       
end;

function Roue:delete()
end;