--
-- HelpPanel
-- Specialization for display additional info
--
-- @author:  	Burner
-- @date:		06.03.2012
-- 
--

HelpPanel = {};

function HelpPanel.prerequisitesPresent(specializations)
    return true;
end;

function HelpPanel:load(xmlFile)
	self.helpPanelPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.HelpPanel#posX"), 0.0095);
	self.helpPanelPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.HelpPanel#posY"), 0.356);
    self.helpPanelWidth = 0.36;
    self.helpPanelHeight = 0.44;
    self.helpPanelOverlay = Overlay:new("helpPanel", Utils.getFilename("Textures/Hud.png", self.baseDirectory), self.helpPanelPoxX, self.helpPanelPoxY, self.helpPanelWidth, self.helpPanelHeight);
	self.helpPanelActive = false;
	
	self.num4Active = false;
	self.num5Active = false;
	self.num6Active = false;
	self.num7Active = false;
	self.num8Active = false;
	self.num9Active = false;
end;

function HelpPanel:delete()
end;

function HelpPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HelpPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function HelpPanel:update(dt)
	self.num4Active = false;
	self.num5Active = false;
	self.num6Active = false;
	self.num7Active = false;
	self.num8Active = false;
	self.num9Active = false;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.NawaroMaus_OpenPanel) then
			self.helpPanelActive = not self.helpPanelActive;
		end;
		if InputBinding.isPressed(InputBinding.NawaroMaus_MoveUp) then
			self.num8Active = true
		elseif InputBinding.isPressed(InputBinding.NawaroMaus_MoveDown) then
			self.num5Active = true;
		elseif InputBinding.isPressed(InputBinding.NawaroMaus_MoveRight) then
			self.num6Active = true;
		elseif InputBinding.isPressed(InputBinding.NawaroMaus_MoveLeft) then
			self.num4Active = true;
		elseif InputBinding.isPressed(InputBinding.NawaroMaus_MoveBack) then
			self.num9Active = true;
		elseif InputBinding.isPressed(InputBinding.NawaroMaus_MoveFront) then
			self.num7Active = true;
		end;
	end;
end;

function HelpPanel:draw()
	if self.helpPanelActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("EuroMaus_HelpPanelOff"), InputBinding.NawaroMaus_OpenPanel);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("EuroMaus_HelpPanelOn"), InputBinding.NawaroMaus_OpenPanel);
	end;
	
	if self.helpPanelActive then
		setTextBold(false);
		if self.helpPanelOverlay ~= nil then
			self.helpPanelOverlay:render();
		end;
		
		if self.currentTool == RopaEuroMaus.PICKUP then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.76, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivatePickup)..": "..g_i18n:getText("pickup"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.76, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivatePickup)..": "..g_i18n:getText("pickup"))));
		end;
		if self.currentTool == RopaEuroMaus.COUNTERWEIGHT then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.74, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateCounterweight)..": "..g_i18n:getText("counterweight"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.74, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateCounterweight)..": "..g_i18n:getText("counterweight"))));
		end;
		if self.animationParts[8].clipEndTime then
			if self.currentTool == RopaEuroMaus.ELEVATOR then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.72, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator)..": "..g_i18n:getText("elevator"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.72, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator)..": "..g_i18n:getText("elevator"))));
			end;
			if self.currentTool == RopaEuroMaus.ELEVATOR_PART2 then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.7, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator_Part2)..": "..g_i18n:getText("elevatorPart2"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.7, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator_Part2)..": "..g_i18n:getText("elevatorPart2"))));
			end;
		else
			setTextColor(0,0,0,0.3);
			renderText(0.0245, 0.72, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator)..": "..g_i18n:getText("elevator"))));
			renderText(0.0245, 0.72, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator)..": "..g_i18n:getText("elevator"))));
			renderText(0.0245, 0.7, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator_Part2)..": "..g_i18n:getText("elevatorPart2"))));
			renderText(0.0245, 0.7, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateElevator_Part2)..": "..g_i18n:getText("elevatorPart2"))));
		end;
		if self.currentTool == RopaEuroMaus.SEAT then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.68, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateSeat)..": "..g_i18n:getText("seat"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.68, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ActivateSeat)..": "..g_i18n:getText("seat"))));
		end;
		
		if self.animationParts[1].currentPosition < 5600 and self.animationParts[1].currentPosition > 1600 then
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.66, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_SteeringMode)..": "..g_i18n:getText("EuroMaus_SteeringMode").." ("..g_i18n:getText("EuroMaus_Current")..": "..self.changeWheelNames[self.changeWheel]..")")));
		else
			setTextColor(0,0,0,0.3);
			renderText(0.0245, 0.66, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_SteeringMode)..": "..g_i18n:getText("EuroMaus_SteeringMode").." ("..g_i18n:getText("EuroMaus_Current")..": "..self.changeWheelNames[self.changeWheel]..")")));
		end;
		
		if self.B3["work"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.64, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Frontwork)..": "..g_i18n:getText("worklight1"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.64, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Frontwork)..": "..g_i18n:getText("worklight1"))));
		end;
		if self.B3["work"][2].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.62, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Leftwork)..": "..g_i18n:getText("worklight2"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.62, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Leftwork)..": "..g_i18n:getText("worklight2"))));
		end;
		if self.B3["work"][3].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.6, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Rightwork)..": "..g_i18n:getText("worklight3"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.6, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Rightwork)..": "..g_i18n:getText("worklight3"))));
		end;
		if self.B3["work"][4].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.58, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Elewatorwork)..": "..g_i18n:getText("worklight4"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.58, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_Elewatorwork)..": "..g_i18n:getText("worklight4"))));
		end;
		
		setTextColor(0,0,0,1);
		renderText(0.0245, 0.56, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_ResetWeighingCounter)..": "..g_i18n:getText("EuroMaus_ResetWeight"))));
		
		if self.B3["dirLeft"][1].a and not self.B3["dirRight"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.54, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3LEFT), "PAD", "")..": "..g_i18n:getText("EuroMaus_LeftBlinker"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.54, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3LEFT), "PAD", "")..": "..g_i18n:getText("EuroMaus_LeftBlinker"))));
		end;
		if self.B3["dirRight"][1].a and not self.B3["dirLeft"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.52, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3RIGHT), "PAD", "")..": "..g_i18n:getText("EuroMaus_RightBlinker"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.52, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3RIGHT), "PAD", "")..": "..g_i18n:getText("EuroMaus_RightBlinker"))));
		end;
		if self.B3["dirLeft"][1].a and self.B3["dirRight"][1].a then
			setTextColor(0.95,0,0,1);
			renderText(0.0245, 0.5, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3WARN), "PAD", "")..": "..g_i18n:getText("EuroMaus_WarnLights"))));
		else
			setTextColor(0,0,0,1);
			renderText(0.0245, 0.5, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3WARN), "PAD", "")..": "..g_i18n:getText("EuroMaus_WarnLights"))));
		end;
		
		if self.currentTool == RopaEuroMaus.PICKUP then
			if self.num8Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveUp), "PAD", "")..": "..g_i18n:getText("pickup_raise"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveUp), "PAD", "")..": "..g_i18n:getText("pickup_raise"))));
			end;
			if self.num5Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("pickup_lower"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("pickup_lower"))));
			end;
		elseif self.currentTool == RopaEuroMaus.COUNTERWEIGHT then
			if self.num4Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("counterweight_left"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("counterweight_left"))));
			end;
			if self.num6Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("counterweight_right"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("counterweight_right"))));
			end;
			if self.num5Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.44, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("counterweight_center"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.44, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("counterweight_center"))));
			end;
		elseif self.currentTool == RopaEuroMaus.ELEVATOR then
			if self.num4Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("elevator_left"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("elevator_left"))));
			end;
			if self.num6Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("elevator_right"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("elevator_right"))));
			end;
		elseif self.currentTool == RopaEuroMaus.ELEVATOR_PART2 then
			if self.num4Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("elevator2_left"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("elevator2_left"))));
			end;
			if self.num6Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("elevator2_right"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("elevator2_right"))));
			end;
			if self.num8Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.44, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveUp), "PAD", "")..": "..g_i18n:getText("elevator3_up"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.44, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveUp), "PAD", "")..": "..g_i18n:getText("elevator3_up"))));
			end;
			if self.num5Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.42, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("elevator3_down"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.42, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("elevator3_down"))));
			end;
			if self.num7Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.4, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveFront), "PAD", "")..": "..g_i18n:getText("elevator4_up"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.4, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveFront), "PAD", "")..": "..g_i18n:getText("elevator4_up"))));
			end;
			if self.num9Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.38, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveBack), "PAD", "")..": "..g_i18n:getText("elevator4_down"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.38, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveBack), "PAD", "")..": "..g_i18n:getText("elevator4_down"))));
			end;
		elseif self.currentTool == RopaEuroMaus.SEAT then
			if self.num4Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("seat_left"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.48, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveLeft), "PAD", "")..": "..g_i18n:getText("seat_left"))));
			end;
			if self.num6Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("seat_right"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.46, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveRight), "PAD", "")..": "..g_i18n:getText("seat_right"))));
			end;
			if self.num5Active then
				setTextColor(0.95,0,0,1);
				renderText(0.0245, 0.44, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("seat_center"))));
			else
				setTextColor(0,0,0,1);
				renderText(0.0245, 0.44, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.NawaroMaus_MoveDown), "PAD", "")..": "..g_i18n:getText("seat_center"))));
			end;
		end;
	end;
	setTextColor(0,0,0,1);
end;