--
-- Disc GD 3.2
--
-- @autor Wallu
--

Grapa = {};

function Grapa.prerequisitesPresent(specializations)
    return true;
end;
function Grapa:load(xmlFile)

	local GrapeNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Grape#index"));
    if GrapeNode ~= nil then
        self.Grape = {};
        self.Grape.node = GrapeNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Grape#minRot"));
        self.Grape.minRot = {};
        self.Grape.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Grape.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Grape.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Grape#maxRot"));
        self.Grape.maxRot = {};
        self.Grape.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Grape.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Grape.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Grape.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Grape#rotTime"), 200);
        self.Grape.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Grape#touchRotLimit"), 10));
    end;

	local LantNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lant#index"));
    if LantNode ~= nil then
        self.Lant = {};
        self.Lant.node = LantNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Lant#minRot"));
        self.Lant.minRot = {};
        self.Lant.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Lant.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Lant.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Lant#maxRot"));
        self.Lant.maxRot = {};
        self.Lant.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Lant.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Lant.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Lant.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Lant#rotTime"), 200);
        self.Lant.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Lant#touchRotLimit"), 10));
    end;

	local Grape1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Grape1#index"));
    if Grape1Node ~= nil then
        self.Grape1 = {};
        self.Grape1.node = Grape1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Grape1#minRot"));
        self.Grape1.minRot = {};
        self.Grape1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Grape1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Grape1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Grape1#maxRot"));
        self.Grape1.maxRot = {};
        self.Grape1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Grape1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Grape1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Grape1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Grape1#rotTime"), 200);
        self.Grape1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Grape1#touchRotLimit"), 10));
    end;

end;

function Grapa:delete()

end;

function Grapa:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Grapa:keyEvent(unicode, sym, modifier, isDown)
end;

function Grapa:update(dt)

if self.inrange or self.isEntered then

	if InputBinding.hasEvent (InputBinding.LasaGrapele) then
		self.openGrape = not self.openGrape;
	end;
	if InputBinding.hasEvent (InputBinding.Lant) then
		self.openLant = not self.openLant;
	end;
	if InputBinding.hasEvent (InputBinding.Grape1) then
		self.openGrape1 = not self.openGrape1;
	end;
end;

	if self.inrange or self.isEntered then

		if self.openGrape then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Ridica Grapele", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LasaGrapele)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Lasa Grapele", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LasaGrapele)));
		end;
	end; 

	if self.Grape ~= nil then
		local x, y, z = getRotation(self.Grape.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Grape.minRot, self.Grape.maxRot, 3, self.Grape.rotTime, dt, self.openGrape);
		setRotation(self.Grape.node, unpack(newRot));
	end;
	if self.Lant ~= nil then
		local x, y, z = getRotation(self.Lant.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Grape.minRot, self.Lant.maxRot, 3, self.Lant.rotTime, dt, self.openLant);
		setRotation(self.Lant.node, unpack(newRot));
	end;
	if self.Grape1 ~= nil then
		local x, y, z = getRotation(self.Grape1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Grape1.minRot, self.Grape1.maxRot, 3, self.Grape1.rotTime, dt, self.openGrape1);
		setRotation(self.Grape1.node, unpack(newRot));
	end;

end;


function Grapa:updateTick(dt)

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function Grapa:draw()  

end;

function Grapa:onLeave()

end;



