SetHotteEvent = {};
SetHotteEvent_mt = Class(SetHotteEvent, Event);

InitEventClass(SetHotteEvent, "SetHotteEvent");

function SetHotteEvent:emptyNew()
    local self = Event:new(SetHotteEvent_mt);
    self.className="SetHotteEvent";
    return self;
end;

function SetHotteEvent:new(vehicle, isPickupState)
    local self = SetHotteEvent:emptyNew()
    self.vehicle = vehicle;
	self.isPickupState = isPickupState;
    return self;
end;

function SetHotteEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isPickupState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetHotteEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isPickupState);
end;

function SetHotteEvent:run(connection)   
	self.vehicle:setPickup(self.isPickupState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetHotteEvent:new(self.vehicle, self.isPickupState), nil, connection, self.vehicle);
    end;
end;

function SetHotteEvent.sendEvent(vehicle, isPickupState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetHotteEvent:new(vehicle, isPickupState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetHotteEvent:new(vehicle, isPickupState));
		end;
	end;
end;