--
-- RollandTCE
-- Specialization for Naud APN 7 corps
--
-- @author  	Benjamin Biot (J&B Modding) et Fendt412
-- @version 	v1.0
-- @date  		21/11/10
--

RollandTCE = {};

function RollandTCE.prerequisitesPresent(specializations)
    return true;
end;

function RollandTCE:load(xmlFile)
 	self.setHotte= SpecializationUtil.callSpecializationsFunction("setHotte");	
	self.HotteAnimation = getXMLString(xmlFile, "vehicle.Hotte#animationName");
	self.Hotte = false;

end;

function RollandTCE:delete()
end;

function RollandTCE:readStream(streamId, connection)
    self:setHotte(streamReadBool(streamId), true);
end;

function RollandTCE:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Hotte);
end;

function RollandTCE:readUpdateStream(streamId, timestamp, connection)
end;

function RollandTCE:writeUpdateStream(streamId, connection, dirtyMask)
end;

function RollandTCE:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RollandTCE:keyEvent(unicode, sym, modifier, isDown)
end;

function RollandTCE:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setHotte(not self.Hotte);
		end;
    end;
end;

function RollandTCE:updateTick(dt)	
end;

function RollandTCE:draw()
	if self.Hotte then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Hotte_ON"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
    else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Hotte_OFF"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
     end;	
end;

function RollandTCE:setHotte(isHotteState,noEventSend)
	SetHotteEvent.sendEvent(self, isHotteState, noEventSend);
	-- Play Hotte animation --
	self.HotteDown = isHotteState;
	if self.HotteDown then
		if self.HotteAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.HotteAnimation, -1, nil, true);
			self.Hotte = true;
		end;
	else
		if self.HotteAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.HotteAnimation, 1, nil, true);
			self.Hotte = false;
		end;
	end;	
end;
