Fouragere = {};

function Fouragere.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function Fouragere:load(xmlFile)
	local rotationNodePartav = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartav#index"));
    if rotationNodePartav ~= nil then
        self.rotationPartav = {};
        self.rotationPartav.node = rotationNodePartav;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartav#minRot"));
        self.rotationPartav.minRot = {};
        self.rotationPartav.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartav.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartav.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartav#maxRot"));
        self.rotationPartav.maxRot = {};
        self.rotationPartav.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartav.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartav.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartav.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartav#rotTime"), 2)*1000;
        self.rotationPartav.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartav#touchRotLimit"), 10));
    end;  

	local rotationNodePartavc = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartavc#index"));
    if rotationNodePartavc ~= nil then
        self.rotationPartavc = {};
        self.rotationPartavc.node = rotationNodePartavc;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartavc#minRot"));
        self.rotationPartavc.minRot = {};
        self.rotationPartavc.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartavc.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartavc.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartavc#maxRot"));
        self.rotationPartavc.maxRot = {};
        self.rotationPartavc.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartavc.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartavc.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartavc.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartavc#rotTime"), 2)*1000;
        self.rotationPartavc.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartavc#touchRotLimit"), 10));
    end;  

	local rotationNodePartar = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartar#index"));
    if rotationNodePartar ~= nil then
        self.rotationPartar = {};
        self.rotationPartar.node = rotationNodePartar;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartar#minRot"));
        self.rotationPartar.minRot = {};
        self.rotationPartar.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartar.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartar.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartar#maxRot"));
        self.rotationPartar.maxRot = {};
        self.rotationPartar.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartar.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartar.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartar.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartar#rotTime"), 2)*1000;
        self.rotationPartar.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartar#touchRotLimit"), 10));
    end;   

	local rotationNodePartarc = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartarc#index"));
    if rotationNodePartarc ~= nil then
        self.rotationPartarc = {};
        self.rotationPartarc.node = rotationNodePartarc;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartarc#minRot"));
        self.rotationPartarc.minRot = {};
        self.rotationPartarc.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartarc.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartarc.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartarc#maxRot"));
        self.rotationPartarc.maxRot = {};
        self.rotationPartarc.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartarc.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartarc.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartarc.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartarc#rotTime"), 2)*1000;
        self.rotationPartarc.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartarc#touchRotLimit"), 10));
    end;   
	self.rotationMaxav = false;
	self.rotationMaxar = false;
	self.rotationMaxavc = false;
	self.rotationMaxarc = false;
end;
function Fouragere:delete()
end;
function Fouragere:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fouragere:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_x then
		self.rotationMaxav = not self.rotationMaxav;
		self.rotationMaxar = not self.rotationMaxar;
		self.rotationMaxavc = not self.rotationMaxavc;
		self.rotationMaxarc = not self.rotationMaxarc;
	end;
end;

function Fouragere:update(dt)
	if self.rotationPartav ~= nil then
        local x, y, z = getRotation(self.rotationPartav.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartav.maxRot, self.rotationPartav.minRot, 3, self.rotationPartav.rotTime, dt, not self.rotationMaxav);
        setRotation(self.rotationPartav.node, unpack(newRot));
    end;   
	if self.rotationPartar ~= nil then
        local x, y, z = getRotation(self.rotationPartar.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartar.maxRot, self.rotationPartar.minRot, 3, self.rotationPartar.rotTime, dt, not self.rotationMaxar);
        setRotation(self.rotationPartar.node, unpack(newRot));
    end;	
	if self.rotationPartavc ~= nil then
        local x, y, z = getRotation(self.rotationPartavc.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartavc.maxRot, self.rotationPartavc.minRot, 3, self.rotationPartavc.rotTime, dt, not self.rotationMaxavc);
        setRotation(self.rotationPartavc.node, unpack(newRot));
    end;   
	if self.rotationPartarc ~= nil then
        local x, y, z = getRotation(self.rotationPartarc.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartarc.maxRot, self.rotationPartarc.minRot, 3, self.rotationPartarc.rotTime, dt, not self.rotationMaxarc);
        setRotation(self.rotationPartarc.node, unpack(newRot));
    end;	
end;

function Fouragere:draw()
	if self.rotationMaxav then
		g_currentMission:addExtraPrintText("Touche X : Deplier les fourrageres");		
	else
		g_currentMission:addExtraPrintText("Touche X : Plier les fourrageres");
	end;
end;