-- xyzspain

rogatorSprayer = {};

function rogatorSprayer.prerequisitesPresent(specializations)
  -- return SpecializationUtil.hasSpecialization(Motorized, specializations);
 
   return true;
end;

function rogatorSprayer:load(xmlFile)
-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.changeSteer = SpecializationUtil.callSpecializationsFunction("changeSteer");
	self.changeWheel = 0; 
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
			-------------------------
		---------flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	 
	self.FlashLightLeft1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl1#index"));
     self.FlashLightRight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr1#index"));	 
	
	
	
    self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
   
    turnSoundFile = Utils.getFilename("turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	-------------------
	---brake light and sound
	self.lightsbrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brake#index"));

	self.braking = false;
	local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
	brakeSound = Utils.getFilename(brakeSound, self.baseDirectory);
        self.brakeSound = createSample("brakeSound");
        loadSample(self.brakeSound, brakeSound, false);
    end;
	

	

			---emision de particulas ruedas

    self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
	

		-------------	Width control
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	local translationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation2#index"));
    if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
      
    end;
	local translationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation3#index"));
    if translationNode3 ~= nil then
        self.translation3 = {};
        self.translation3.node = translationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#minTrans"));
        self.translation3.minTrans = {};
        self.translation3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#maxTrans"));
        self.translation3.maxTrans = {};
        self.translation3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation3#transTime"), 2)*1000;
      
    end;
	local translationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation4#index"));
    if translationNode4 ~= nil then
        self.translation4 = {};
        self.translation4.node = translationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation4#minTrans"));
        self.translation4.minTrans = {};
        self.translation4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation4#maxTrans"));
        self.translation4.maxTrans = {};
        self.translation4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation4.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation4#transTime"), 2)*1000;
      
    end;
	
	local translationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation5#index"));
    if translationNode5 ~= nil then
        self.translation5 = {};
        self.translation5.node = translationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation5#minTrans"));
        self.translation5.minTrans = {};
        self.translation5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation5#maxTrans"));
        self.translation5.maxTrans = {};
        self.translation5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation5.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation5#transTime"), 2)*1000;
      
    end;
	local translationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation6#index"));
    if translationNode6 ~= nil then
        self.translation6 = {};
        self.translation6.node = translationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation6#minTrans"));
        self.translation6.minTrans = {};
        self.translation6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation6#maxTrans"));
        self.translation6.maxTrans = {};
        self.translation6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation6.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation6#transTime"), 2)*1000;
      
    end;
	---------------------------
		 local rotationPartNodeLeftDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#index"));
    if rotationPartNodeLeftDoor ~= nil then
        self.rotationPartLeftDoor = {};
        self.rotationPartLeftDoor.node = rotationPartNodeLeftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#minRot"));
        self.rotationPartLeftDoor.minRot = {};
        self.rotationPartLeftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#maxRot"));
        self.rotationPartLeftDoor.maxRot = {};
        self.rotationPartLeftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#rotTime"), 2)*1000;
        self.rotationPartLeftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#touchRotLimit"), 10));
    end;
		 local rotationPartNodeLadder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLadder#index"));
    if rotationPartNodeLadder ~= nil then
        self.rotationPartLadder = {};
        self.rotationPartLadder.node = rotationPartNodeLadder;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLadder#minRot"));
        self.rotationPartLadder.minRot = {};
        self.rotationPartLadder.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLadder.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLadder.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLadder#maxRot"));
        self.rotationPartLadder.maxRot = {};
        self.rotationPartLadder.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLadder.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLadder.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLadder.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLadder#rotTime"), 2)*1000;
        self.rotationPartLadder.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLadder#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartBrake#index"));
    if rotationPartNodeBrake ~= nil then
        self.rotationPartBrake = {};
        self.rotationPartBrake.node = rotationPartNodeBrake;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#minRot"));
        self.rotationPartBrake.minRot = {};
        self.rotationPartBrake.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#maxRot"));
        self.rotationPartBrake.maxRot = {};
        self.rotationPartBrake.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartBrake.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#rotTime"), 2)*1000;
        self.rotationPartBrake.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#touchRotLimit"), 10));
    end;
	
	
	---------------mirros with activation 
	local mirrorLeftNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrorLeft#index"));
        self.mirrorLeft = {};
          self.mirrorLeft.node = mirrorLeftNode;


	

	local mirrorRightNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrorRight#index"));
        self.mirrorRight = {};
          self.mirrorRight.node = mirrorRightNode;
	
	
	
	local headSupportNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.headSupport#index"));
        self.headSupport = {};
          self.headSupport.node = headSupportNode;
local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
	end;
	
	self.indoorCamIndex = 2;
	self.outdoorCamIndex = 1;
	--------------------
	-------------WIPER
	local rotationPartNodeWischer = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischer#index"));
    if rotationPartNodeWischer ~= nil then
        self.rotationPartWischer = {};
        self.rotationPartWischer.node = rotationPartNodeWischer;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer#minRot"));
        self.rotationPartWischer.minRot = {};
        self.rotationPartWischer.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer#maxRot"));
        self.rotationPartWischer.maxRot = {};
        self.rotationPartWischer.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischer.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer#rotTime"), 2)*1000;
        self.rotationPartWischer.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWischerblatt = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#index"));
    if rotationPartNodeWischerblatt ~= nil then
        self.rotationPartWischerblatt = {};
        self.rotationPartWischerblatt.node = rotationPartNodeWischerblatt;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#minRot"));
        self.rotationPartWischerblatt.minRot = {};
        self.rotationPartWischerblatt.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerblatt.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerblatt.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#maxRot"));
        self.rotationPartWischerblatt.maxRot = {};
        self.rotationPartWischerblatt.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerblatt.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerblatt.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischerblatt.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#rotTime"), 2)*1000;
        self.rotationPartWischerblatt.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#touchRotLimit"), 10));
    end;
	local rotationPartNodeWischer1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischer1#index"));
    if rotationPartNodeWischer1 ~= nil then
        self.rotationPartWischer1 = {};
        self.rotationPartWischer1.node = rotationPartNodeWischer1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer1#minRot"));
        self.rotationPartWischer1.minRot = {};
        self.rotationPartWischer1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer1#maxRot"));
        self.rotationPartWischer1.maxRot = {};
        self.rotationPartWischer1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischer1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer1#rotTime"), 2)*1000;
        self.rotationPartWischer1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer1#touchRotLimit"), 10));
    end;
	  self.delayWischer1 = 0;
		self.delayWischer2 = 0;
		
	self.controlpath = Utils.getFilename("menu.png", self.baseDirectory);
   
    
    self.hudRogatorSprayerWidth = 0.526;
    self.hudRogatorSprayerHeight = 0.320;
    self.hudRogatorSprayerPoxX = 0;
    self.hudRogatorSprayerPoxY = 0;
    self.hudRogatorSprayerOverlay = Overlay:new("hudRogatorSprayer", self.controlpath, self.hudRogatorSprayerPoxX, self.hudRogatorSprayerPoxY, self.hudRogatorSprayerWidth, self.hudRogatorSprayerHeight);
     self.bcActive = false;
	
	-------------------	
	self.rotationMaxLeftDoor=true;	
		
				---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	-- self.low=true;
	---------------------------	
		
		
		
	
	
end;
function rogatorSprayer:delete()
    if self.brakePlaying ~= nil then
        stopSample(self.brakeSoundId);
    end;
    if self.hudRogatorSprayerOverlay ~= nil then
        self.hudRogatorSprayerOverlay:delete();
    end;
    for _, entry in ipairs(self.wheelParticleSystems) do
        Utils.deleteParticleSystem(entry.particleSystems);
        entry.isActive = false;
    end;
end;

function rogatorSprayer:mouseEvent(posX, posY, isDown, isUp, button)
end;


function rogatorSprayer:onLeave()
    
	
end;
function rogatorSprayer:keyEvent(unicode, sym, modifier, isDown)
  

end;
function rogatorSprayer:update(dt)
	
if self:getIsActive() then 
	


	
	
---flashlights
	
	if InputBinding.hasEvent (InputBinding.FLASH_LEFT)  then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
	end;

	if InputBinding.hasEvent (InputBinding.FLASH_RIGHT)  then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if InputBinding.hasEvent (InputBinding.WARNINGS) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;
	
	if self.FlashLightLeft ~= nil then
              if self.flashLightLeftActive then
            	setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
			 setVisibility(self.FlashLightLeft1, self.flashLightLeftActive);
	    else
            	setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
				 setVisibility(self.FlashLightLeft1, self.flashLightLeftActive);
	    end;
        end;

	if self.FlashLightRight ~= nil then
           if self.FlashLightRightActive then
            	setVisibility(self.FlashLightRight, self.flashLightRightActive);
				setVisibility(self.FlashLightRight1, self.flashLightRightActive);
	    else
            	setVisibility(self.FlashLightRight, self.flashLightRightActive);
				 setVisibility(self.FlashLightRight1, self.flashLightRightActive);
	    end;
        end;

	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashLightLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 200;
				self.flashLightLeftActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashLightLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 200;
				self.flashLightLeftActive = false;
			end;
		end;
	end;

	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashLightRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 200;
				self.flashLightRightActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashLightRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 200;
				self.flashLightRightActive = false;
			end;
		end;
	end;

	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashLightRightActive then
			if self.delayOn < 0 then
				self.delayOff = 200;
				self.flashLightRightActive = true;
				self.flashLightLeftActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashLightRightActive then
			if self.delayOff < 0 then
				self.delayOn = 200;
				self.flashLightLeftActive = false;
				self.flashLightRightActive = false;
			end;
		end;
	end;

	if not self.flashLeft and not self.flashRight then
		if not self.flash then
			self.flashLightRightActive = false;
			self.flashLightLeftActive = false;
		end;
	end;
		
	if not self.flash and not self.flashLeft then
		if not self.flashRight then
			self.flashLightRightActive = false;
		end;
	end;

	if not self.flash and not self.flashRight then
		if not self.flashLeft then
			self.flashLightLeftActive = false;
		end;
	end;
	
	
	--------------------brake------------------------
   inputAxis_2 = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxis_2 = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
	
		if (self.movingDirection*self.lastSpeed*(-inputAxis_2)) < -0.001 then
			setVisibility(self.lightsbrake, true);
			
			-- if not self.brakeSoundRunning then
					-- playSample(self.brakeSound, 1, 1, 0);
					-- self.brakeSoundRunning = true;
					
				-- end;
			self.braking = true;
			
			self.rotationMaxBrake=true;
		else
		     setVisibility(self.lightsbrake, false);
			self.rotationMaxBrake=false;
	
			self.braking = false;
			self.brakeSoundRunning = false;	
		
		end;

	---particulas ruedas

	local dens = 0; local dens1; local dens2; local dens3;
		 local x,y,z = getWorldTranslation(self.wheels[1].repr);
		 local x1,y1,z1 = getWorldTranslation(self.wheels[2].repr);
		 local x2,y2,z2 = getWorldTranslation(self.wheels[3].repr);
		local id = g_currentMission.terrainDetailId;
		local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
		dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
		dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
		dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
		if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			dens = dens1+dens2+dens3;
		end;
		if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
			
			
			for k=1, 4 do
				Utils.setEmittingState(self.wheelParticleSystems[k].particleSystems, self.wheels[k].hasGroundContact);
			end;
		else
			for i=1, table.getn(self.wheelParticleSystems) do
				Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
			end;
		
		end;
		
		
			
		if InputBinding.hasEvent (InputBinding.INFOHUD) then
				self.bcActive = not self.bcActive;
			end;
		
	----width control
		if InputBinding.isPressed(InputBinding.WIDTH_MAX) and InputBinding.isPressed(InputBinding.ACTIVATION) then
			self.width_max = not  self.width_max;
		end;
		if  InputBinding.isPressed(InputBinding.WIDTH_MIN) and InputBinding.isPressed(InputBinding.ACTIVATION) then
			self.width_min = not  self.width_min;
		end;

		----height control arn
		if InputBinding.isPressed(InputBinding.HEIGHT_MAX) and InputBinding.isPressed(InputBinding.ACTIVATION) then
			self.height_max = not  self.height_max;
		end;
		if  InputBinding.isPressed(InputBinding.HEIGHT_MIN) and InputBinding.isPressed(InputBinding.ACTIVATION) then
			self.height_min = not  self.height_min;
		end;
		
		local x, y, z = getTranslation(self.translation5.node)
				if y ~=0 then
				self.low=true;
				elseif y ==0  then
				self.low=false;
				end;
		
		
		
		
		
		
		
		--------left door
	
	if InputBinding.isPressed (InputBinding.LEFT_DOOR) and InputBinding.isPressed(InputBinding.ACTIVATION) then
		self.rotationMaxLeftDoor = not self.rotationMaxLeftDoor;	
	end;	
	
		--------ladder
	
	if InputBinding.isPressed (InputBinding.LADDER) and InputBinding.isPressed(InputBinding.ACTIVATION) then
		self.rotationMaxLadder = not self.rotationMaxLadder;	
	end;	

-----------------mirrors
			if InputBinding.isPressed (InputBinding.MIRRORS_UP) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.down=not self.down;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_DOWN) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.up=not self.up;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_LEFT) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.left=not self.left;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_RIGHT) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.right=not self.right;
			end;
			
	
		
	if self.camIndex == self.indoorCamIndex or self.camIndex == self.outdoorCamIndex then
				local indoorCam = self.cameras[self.indoorCamIndex];
				local outdoorCam = self.cameras[self.outdoorCamIndex];
		if self.camIndex == self.indoorCamIndex then
		self.mirror=true
		elseif self.camIndex == self.outdoorCamIndex then
		self.mirror=false
		end;
		
			setVisibility(self.mirrorLeft.node, self.mirror);
			setVisibility(self.mirrorRight.node, self.mirror);
			
			setVisibility(self.headSupport.node, not self.mirror);
	end;
	
	---- wiper
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			self.rainWarning = false;
		else
			self.rainWarning = true;
		end;
		
		if self.rainWarning and self.isMotorStarted then
			if self.delayWischer1 >= 0 then
				self.delayWischer1 = self.delayWischer1 -dt;
			end;
			if self.delayWischer2 >= 0 then
				self.delayWischer2 = self.delayWischer2 -dt;
			end;
			if not self.rotationMaxWischer then
				if self.delayWischer1 < 0 then
					self.delayWischer2 = 1000;
					self.rotationMaxWischer = true;
					self.rotationMaxWischer1 = true;
					self.rotationMaxWischerblatt = true;
				end;
			end;
			if self.rotationMaxWischer then
				if self.delayWischer2 < 0 then
					self.delayWischer1 = 1000;
					self.rotationMaxWischer = false;
					self.rotationMaxWischer1 = false;
					self.rotationMaxWischerblatt = false;
				end;
			end;
		else
			self.rotationMaxWischer = false;
			self.rotationMaxWischer1 = false;
			self.rotationMaxWischerblatt = false;
		end;
		
		
		
		----change wheel----
			if InputBinding.hasEvent(InputBinding.ClaasCougar1400_changeWheel) then
			self.changeWheel = self.changeWheel +1 ; 
		end; 
		
		if self.changeWheel == 0  then
			self:changeSteer(30, -30, 30, -30, 30, -30, 30, -30)
		elseif self.changeWheel == 1 then
			self:changeSteer(30, -30, 30, -30, 0, 0, 0, 0)
		elseif self.changeWheel == 2 then
			self.changeWheel = 0; 
		end; 
	
end;

	if self.rotationPartWischer ~= nil then
		local x, y, z = getRotation(self.rotationPartWischer.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischer.maxRot, self.rotationPartWischer.minRot, 3, self.rotationPartWischer.rotTime, dt, not self.rotationMaxWischer);
		setRotation(self.rotationPartWischer.node, unpack(newRot));
	end;  
    if self.rotationPartWischerblatt ~= nil then
		local x, y, z = getRotation(self.rotationPartWischerblatt.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischerblatt.maxRot, self.rotationPartWischerblatt.minRot, 3, self.rotationPartWischerblatt.rotTime, dt, not self.rotationMaxWischerblatt);
		setRotation(self.rotationPartWischerblatt.node, unpack(newRot));
	end;
	if self.rotationPartWischer1 ~= nil then
		local x, y, z = getRotation(self.rotationPartWischer1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischer1.maxRot, self.rotationPartWischer1.minRot, 3, self.rotationPartWischer1.rotTime, dt, not self.rotationMaxWischer1);
		setRotation(self.rotationPartWischer1.node, unpack(newRot));
	end;  

		if self.down then
			local rotationPart = self.rotationParts.rotationPart3;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart4;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;		
		if self.up then
			local rotationPart = self.rotationParts.rotationPart3;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart4;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;  		

		if self.left then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart2;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;		
		if self.right then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart2;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;  		
			






	if self.rotationPartBrake ~= nil then
			local x, y, z = getRotation(self.rotationPartBrake.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartBrake.maxRot, self.rotationPartBrake.minRot, 3, self.rotationPartBrake.rotTime, dt, not self.rotationMaxBrake);
			setRotation(self.rotationPartBrake.node, unpack(newRot));
		end;
		
	   if self.rotationPartLeftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartLeftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeftDoor.maxRot, self.rotationPartLeftDoor.minRot, 3, self.rotationPartLeftDoor.rotTime, dt, not self.rotationMaxLeftDoor);
		   setRotation(self.rotationPartLeftDoor.node, unpack(newRot));
        end;
		  if self.rotationPartLadder ~= nil then
		   local x, y, z = getRotation(self.rotationPartLadder.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLadder.maxRot, self.rotationPartLadder.minRot, 3, self.rotationPartLadder.rotTime, dt, not self.rotationMaxLadder);
		   setRotation(self.rotationPartLadder.node, unpack(newRot));
        end;
	if self.width_max	then
		if self.translation1 ~= nil  then 
			local x, y, z = getTranslation(self.translation1.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, true); 
			setTranslation(self.translation1.node, unpack(newTrans)); 
		end;
		if self.translation2 ~= nil  then 
				local x, y, z = getTranslation(self.translation2.node); 
				local trans = {x,y,z}; 
				local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, true); 
				setTranslation(self.translation2.node, unpack(newTrans)); 
			end;
		if self.translation3 ~= nil  then 
					local x, y, z = getTranslation(self.translation3.node); 
					local trans = {x,y,z}; 
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation3.maxTrans, self.translation3.minTrans, 3, self.translation3.transTime, dt, true); 
					setTranslation(self.translation3.node, unpack(newTrans)); 
				end;
		if self.translation4 ~= nil  then 
					local x, y, z = getTranslation(self.translation4.node); 
					local trans = {x,y,z}; 
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation4.maxTrans, self.translation4.minTrans, 3, self.translation4.transTime, dt, true); 
					setTranslation(self.translation4.node, unpack(newTrans)); 
				end;

		
	end;
		if self.width_min	then
		if self.translation1 ~= nil  then 
			local x, y, z = getTranslation(self.translation1.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, false); 
			setTranslation(self.translation1.node, unpack(newTrans)); 
		end;
		if self.translation2 ~= nil  then 
				local x, y, z = getTranslation(self.translation2.node); 
				local trans = {x,y,z}; 
				local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, false); 
				setTranslation(self.translation2.node, unpack(newTrans)); 
			end;
		if self.translation3 ~= nil  then 
					local x, y, z = getTranslation(self.translation3.node); 
					local trans = {x,y,z}; 
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation3.maxTrans, self.translation3.minTrans, 3, self.translation3.transTime, dt, false); 
					setTranslation(self.translation3.node, unpack(newTrans)); 
				end;
		if self.translation4 ~= nil  then 
					local x, y, z = getTranslation(self.translation4.node); 
					local trans = {x,y,z}; 
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation4.maxTrans, self.translation4.minTrans, 3, self.translation4.transTime, dt, false); 
					setTranslation(self.translation4.node, unpack(newTrans)); 
				end;
		
	end;	
if self.height_max	then
		if self.translation5 ~= nil  then 
			local x, y, z = getTranslation(self.translation5.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translation5.maxTrans, self.translation5.minTrans, 3, self.translation5.transTime, dt, true); 
			setTranslation(self.translation5.node, unpack(newTrans)); 
		end;
		if self.translation6 ~= nil  then 
				local x, y, z = getTranslation(self.translation6.node); 
				local trans = {x,y,z}; 
				local newTrans = Utils.getMovedLimitedValues(trans, self.translation6.maxTrans, self.translation6.minTrans, 3, self.translation6.transTime, dt, true); 
				setTranslation(self.translation6.node, unpack(newTrans)); 
			end;
		

		
	end;
		if self.height_min	then
		if self.translation5 ~= nil  then 
			local x, y, z = getTranslation(self.translation5.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translation5.maxTrans, self.translation5.minTrans, 3, self.translation5.transTime, dt, false); 
			setTranslation(self.translation5.node, unpack(newTrans)); 
		end;
		if self.translation6 ~= nil  then 
				local x, y, z = getTranslation(self.translation6.node); 
				local trans = {x,y,z}; 
				local newTrans = Utils.getMovedLimitedValues(trans, self.translation6.maxTrans, self.translation6.minTrans, 3, self.translation6.transTime, dt, false); 
				setTranslation(self.translation6.node, unpack(newTrans)); 
			end;
		
	end;
	--- asignacion de ejes de libertad  de rotacion segun condiciones de emsamblage  0 x, 2 z ,1 y 
		
		
	self:setJointRotLimit(self.componentJoints[7],2, 0, 1000,self.low==true , 2,dt);		
	-- juntas

			for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
		self:setHydraulicDirection();



end;
function rogatorSprayer:draw()
 if self.hudRogatorSprayerOverlay ~= nil then
  if self.bcActive then
    self.hudRogatorSprayerOverlay:render();
  end;
end;

		if self.bcActive then	
			g_currentMission:addExtraPrintText("play 0: INFO ON");
		else
			g_currentMission:addExtraPrintText("play 0: INFO Off");
		end;  
end;
function rogatorSprayer:onEnter()
	self.flashLightRightActive = false;
	self.flashLightLeftActive = false;
	setVisibility(self.FlashLightRight, false);
	setVisibility(self.FlashLightLeft, false);
	setVisibility(self.lightsbrake, false);
	
	self.rotationMaxLadder= true;
	self.rotationMaxLeftDoor=true;
end;
function rogatorSprayer:onLeave()
	self.flashLightRightActive = false;
	self.flashLightLeftActive = false;
	setVisibility(self.FlashLightRight, false);
	setVisibility(self.FlashLightLeft, false);
	setVisibility(self.lightsbrake, false);
	self.rotationMaxLeftDoor=true;
	self.rotationMaxLadder= false;
	
end;
function rogatorSprayer:changeSteer(wheel11,wheel12, wheel21, wheel22, wheel31, wheel32, wheel41, wheel42)
	if not self.trsp then
		self.wheels[1].rotSpeed = Utils.degToRad(35); 
		self.wheels[2].rotSpeed = Utils.degToRad(35);
		self.wheels[3].rotSpeed = Utils.degToRad(-35); 
		self.wheels[4].rotSpeed = Utils.degToRad(-35); 
	else
		self.wheels[1].rotSpeed = Utils.degToRad(-35); 
		self.wheels[2].rotSpeed = Utils.degToRad(-35);
		self.wheels[3].rotSpeed = Utils.degToRad(35); 
		self.wheels[4].rotSpeed = Utils.degToRad(35); 
	end; 
	self.wheels[1].rotMax = Utils.degToRad(wheel11); 
	self.wheels[2].rotMax = Utils.degToRad(wheel21); 
	self.wheels[1].rotMin = Utils.degToRad(wheel12); 
	self.wheels[2].rotMin = Utils.degToRad(wheel22);	
	self.wheels[3].rotMax = Utils.degToRad(wheel31); 
	self.wheels[4].rotMax = Utils.degToRad(wheel41); 
	self.wheels[3].rotMin = Utils.degToRad(wheel32); 
	self.wheels[4].rotMin = Utils.degToRad(wheel42); 			
end; 
		
function rogatorSprayer:setHydraulicDirection()
		for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;
function rogatorSprayer:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;