--
-- superSiloTrigger
--
-- MOD by Defender
--

print("MapMOD: superSiloTrigger loaded 13.1");

superSiloPresenter = {};

function superSiloPresenter:loadMap(name)
  print("superSiloPresenter loaded");
  if g_currentMission.superSiloPresenter == nil then
     g_currentMission.superSiloPresenter = {};
  end;
end;

function superSiloPresenter:deleteMap()
end;

function superSiloPresenter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function superSiloPresenter:keyEvent(unicode, sym, modifier, isDown)
end;

function superSiloPresenter:update(dt)
end;

function superSiloPresenter:draw()
  if g_currentMission.superSiloPresenter~=nil then
    for i=1, table.maxn(g_currentMission.superSiloPresenter) do
      if g_currentMission.superSiloPresenter[i]~=nil then
        g_currentMission.superSiloPresenter[i]:draw();
      end;
    end;
  end;
end;

addModEventListener(superSiloPresenter);


superSiloTrailerInTriggerEvent = {};
superSiloTrailerInTriggerEvent_mt = Class(superSiloTrailerInTriggerEvent, Event);

InitEventClass(superSiloTrailerInTriggerEvent, "superSiloTrailerInTriggerEvent");

function superSiloTrailerInTriggerEvent:emptyNew()
    local self = Event:new(superSiloTrailerInTriggerEvent_mt);
    self.className="superSiloTrailerInTriggerEvent";
    return self;
end;

function superSiloTrailerInTriggerEvent:new(object, trailer)
    local self = superSiloTrailerInTriggerEvent:emptyNew()
    self.object = object;
    self.trailer = trailer;
    return self;
end;

function superSiloTrailerInTriggerEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    local nID = streamReadInt32(streamId)
    self.trailer = nil;
    if nID ~= 0 then
      self.trailer = networkGetObject(nID);
    end;
    self:run(connection);
end;

function superSiloTrailerInTriggerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    local nID = 0;
    if self.trailer ~= nil then
      nID=networkGetObjectId(self.trailer);    
    end;
    streamWriteInt32(streamId, nID);
end;

function superSiloTrailerInTriggerEvent:run(connection)
    superSiloTrailerInTriggerEvent.execute(self.object, self.trailer);
end;

function superSiloTrailerInTriggerEvent.execute(object, trailer)
  object.trailer = trailer;
end;




superSiloSetupEvent = {};
superSiloSetupEvent_mt = Class(superSiloSetupEvent, Event);

InitEventClass(superSiloSetupEvent, "superSiloSetupEvent");

function superSiloSetupEvent:emptyNew()
    local self = Event:new(superSiloSetupEvent_mt);
    self.className="superSiloSetupEvent";
    return self;
end;

function superSiloSetupEvent:new(object, actualfruit, fill )
    local self = superSiloSetupEvent:emptyNew()
    self.object = object;
    self.actualfruit = actualfruit;
    self.fill = fill;
    return self;
end;

function superSiloSetupEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.actualfruit = streamReadInt8(streamId);
    self.fill = streamReadBool(streamId);
    self:run(connection);
end;

function superSiloSetupEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.actualfruit);
    streamWriteBool(streamId, self.fill);
end;

function superSiloSetupEvent:run(connection)
    superSiloSetupEvent.execute(self.object, self.actualfruit, self.fill);
end;

function superSiloSetupEvent.execute(object, actualfruit, fill)
    object.actualfruit = actualfruit;
    object.fill = fill;
    local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[object.fruits[actualfruit]].name);
    object.fillType = FruitUtil[key];
    local actualfill = FruitUtil.fruitTypeToFillType[actualfruit];
    object.subHudBack = Utils.getFilename(Fillable.fillTypeIndexToDesc[actualfill].hudOverlayFilename, object.baseDirectory);
    object.fruitHud = Overlay:new("fruitHud",object.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);
end;




superSiloTrigger = {};

local superSiloTrigger_mt = Class(superSiloTrigger, Object);

function superSiloTrigger:OnCreate(id)
    local trigger = superSiloTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

function superSiloTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, superSiloTrigger_mt);
    self.className = "superSiloTrigger";
    self.rootNode = 0;

    self.superSiloTriggerDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

superSiloOnCreate = superSiloTrigger.OnCreate; 

function superSiloTrigger:load(id)
  if g_currentMission.superSiloPresenter == nil then
    g_currentMission.superSiloPresenter = {};
  end;
  table.insert(g_currentMission.superSiloPresenter,self);
  self.startFilling = superSiloTrigger.startFilling;
  self.stopFilling = superSiloTrigger.stopFilling;
  self.rootNode = id;
  if self.isServer then
    addTrigger(id, "superSiloTriggerCallback", self);
  end;
  self.fillSpeed = Utils.getNoNil(getUserAttribute(id, "fillSpeed"), 1);
  self.id = id;
  
  self.trailerInTrigger = 0;
  self.fruitTriggerId = 0;

  self.fill = false;
  self.printText = false;

  self.fruits = {};
  local i = 0;
  for a=1, FruitUtil.NUM_FRUITTYPES do
    if (FruitUtil.fruitIndexToDesc[a].allowsSeeding) and (FruitUtil.fruitIndexToDesc[a].name~="grass") and (FruitUtil.fruitIndexToDesc[a].name~="potato") and (FruitUtil.fruitIndexToDesc[a].name~="sugarBeet") then
      i=i+1;
      self.fruits[i]=a;
    end;      
  end;
  self.fruitscount=i;
  self.actualfruit=1;
  local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.actualfruit].name);
  self.fillType = FruitUtil[key];

  local actualfill = FruitUtil.fruitTypeToFillType[self.fillType];
  self.subHudBack = Utils.getFilename(Fillable.fillTypeIndexToDesc[actualfill].hudOverlayFilename, self.baseDirectory);

  self.fruitHud = Overlay:new("fruitHud",self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);
  
  if self.isClient then
    self.siloParticleSystemRoot = loadI3DFile("data/vehicles/particleSystems/wheatParticleSystemLong.i3d");
    local x,y,z = localToWorld(self.id, -0.05, 0.15, 0.05);
    setTranslation(self.siloParticleSystemRoot, x, y, z);
    link(getRootNode(), self.siloParticleSystemRoot);

    for i=0, getNumOfChildren(self.siloParticleSystemRoot)-1 do
      local child = getChildAt(self.siloParticleSystemRoot, i);
      if getClassName(child) == "Shape" then
        local geometry = getGeometry(child);
        if geometry ~= 0 then
          if getClassName(geometry) == "ParticleSystem" then
            self.siloParticleSystem = geometry;
          end;
        end;
      end;
    end;

    if self.siloParticleSystem ~= nil then
      setEmittingState(self.siloParticleSystem, false);
    end;
  end;
  self.ShowHud=false;
end;

function superSiloTrigger:loadMap(name)  
end;

function superSiloTrigger:deleteMap()
end;

function superSiloTrigger:delete()
  if self.isServer then
    removeTrigger(self.id);
  end;

  if self.siloParticleSystemRoot ~= nil then
    delete(self.siloParticleSystemRoot);
  end;

  delete(self.rootNode);
  SiloTrigger:superClass().delete(self);
end;

function superSiloTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function superSiloTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function superSiloTrigger:readStream(streamId, connection)
    superSiloTrigger:superClass().readStream(self, streamId);
    if connection:getIsServer() then
      self.fill = streamReadBool(streamId);
      self.actualfruit = streamReadInt8(streamId);
      local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name);
      self.fillType = FruitUtil[key];

      local actualfill = FruitUtil.fruitTypeToFillType[self.fillType];
      self.subHudBack = Utils.getFilename(Fillable.fillTypeIndexToDesc[actualfill].hudOverlayFilename, self.baseDirectory);

      self.fruitHud = Overlay:new("fruitHud",self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);
    end;
end;

function superSiloTrigger:writeStream(streamId, connection)
    superSiloTrigger:superClass().writeStream(self, streamId);
    if not connection:getIsServer() then
      streamWriteBool(streamId, self.fill);
      streamWriteInt8(streamId, self.actualfruit);
    end;
end;

function superSiloTrigger:readUpdateStream(streamId, timestamp, connection)

end;

function superSiloTrigger:writeUpdateStream(streamId, connection, dirtyMask)

end;

function superSiloTrigger:update(dt)
  if self.isClient then

    if self.trailer ~= nil and self.trailer:getIsActiveForInput() then
      self.printText = false;
      if self.trailer.fillTypes ~= nil and self.trailer.setFillLevel ~= nil and self.trailer.fillLevel ~= nil then
        if not self.fill then
          g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_CHOOSEFRUIT"),InputBinding.IMPLEMENT_EXTRA2);

          if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2)  then
            self.actualfruit=self.actualfruit+1;
            if self.actualfruit>self.fruitscount then
              self.actualfruit=1;
            end;
            local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name);
            self.fillType = FruitUtil[key];

            local actualfill = FruitUtil.fruitTypeToFillType[self.fillType];
            self.subHudBack = Utils.getFilename(Fillable.fillTypeIndexToDesc[actualfill].hudOverlayFilename, self.baseDirectory);

            self.fruitHud = Overlay:new("fruitHud",self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);

            if g_server ~= nil then
                g_server:broadcastEvent(superSiloSetupEvent:new(self, self.actualfruit, self.fill), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(superSiloSetupEvent:new(self, self.actualfruit, self.fill));
            end;
          end;
        end;
        self.ShowHud=true;
        local realFillType = FruitUtil.fruitTypeToFillType[self.fillType];
        local fillName = Fillable.fillTypeIntToName[realFillType]; 
        
        if realFillType == self.trailer.currentFillType or self.trailer.currentFillType == Fillable.FILLTYPE_UNKNOWN then
          if self.trailer.fillLevel < self.trailer.capacity and self.trailer:allowFillType(realFillType, true) then
            self.printText = true;
            if self.fill and self.printText then
              g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_STOPFILL"),InputBinding.SUPERSILO_FILL);
            elseif self.printText then
              g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_STARTFILL"),InputBinding.SUPERSILO_FILL);
            end;
            if InputBinding.hasEvent(InputBinding.SUPERSILO_FILL)  then
              if self.fill then
                self:stopFilling();
              else
                self:startFilling();
              end;
            end;
          end;
        end;
      end;
    else
      self.ShowHud = false;
    end;
    setEmittingState(self.siloParticleSystem, self.fill);
  end;
  if self.isServer and self.trailer~=nil then
    local _realFillType = FruitUtil.fruitTypeToFillType[self.fillType];
        
    if (_realFillType == self.trailer.currentFillType or self.trailer.currentFillType == Fillable.FILLTYPE_UNKNOWN) and self.trailer:allowFillType(_realFillType, true) then
      if self.trailer.fillLevel < self.trailer.capacity then
        if self.fill then
          self.trailer:resetFillLevelIfNeeded(_realFillType);
          local deltaFillLevel = dt*self.fillSpeed;
          if g_currentMission:getSiloAmount(_realFillType)<=deltaFillLevel then
            deltaFillLevel=g_currentMission:getSiloAmount(_realFillType);
            self:stopFilling();
          end;
          if deltaFillLevel>0 then
        self.trailer:setFillLevel(self.trailer.fillLevel+deltaFillLevel, _realFillType);
            g_currentMission:setSiloAmount(_realFillType, g_currentMission:getSiloAmount(_realFillType)- deltaFillLevel);
          end;
          if g_currentMission:getSiloAmount(_realFillType)<=0 then
            g_currentMission:setSiloAmount(_realFillType,0);
            self:stopFilling();
          end;
        end;
      else
        if self.fill then
          self:stopFilling();
        end;
      end;
    end;
  end;
end;

function superSiloTrigger:startFilling()
  self.fill = true;
  if g_server ~= nil then
    g_server:broadcastEvent(superSiloSetupEvent:new(self, self.actualfruit, true), nil, nil, self);
  else
    g_client:getServerConnection():sendEvent(superSiloSetupEvent:new(self, self.actualfruit, true));
  end;
end;

function superSiloTrigger:stopFilling()
  self.fill = false;
  if g_server ~= nil then
    g_server:broadcastEvent(superSiloSetupEvent:new(self, self.actualfruit, false), nil, nil, self);
  else
    g_client:getServerConnection():sendEvent(superSiloSetupEvent:new(self, self.actualfruit, false));
  end;
end;


function superSiloTrigger:draw()
  if self.ShowHud then
    self.fruitHud:render();
    local s=g_i18n:getText(FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name);
    if string.find(s,".xml")~=nil then              
      s=FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name;
    end;
    setTextBold(false);
    setTextColor(1,1,1,1);
    setTextAlignment(RenderText.ALIGN_CENTER);
    renderText(0.01+(g_currentMission.hudTipperOverlay.width/2), 0.01+g_currentMission.hudTipperOverlay.height+0.02,0.02,s);
  end;
end;

function superSiloTrigger:superSiloTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  assert(self.isServer);
  local trailer = g_currentMission.objectToTrailer[otherShapeId];
  if trailer ~= nil and trailer.allowFillFromAir then
    if onEnter then
      self.trailerInTrigger = otherId;
      self.trailer = trailer;
      g_server:broadcastEvent(superSiloTrailerInTriggerEvent:new(self, trailer));
      self.fruitTriggerId = triggerId;
    elseif onLeave then
      self.trailerInTrigger = 0;
      self.trailer = nil;
      self.fruitTriggerId = 0;
      g_server:broadcastEvent(superSiloTrailerInTriggerEvent:new(self, nil));
      self:stopFilling();
    end;
  end;
end;