--
-- Ploughing specialization
--
-- author: Burner
-- date: 24.05.2011
-- total rebuild date: 07.04.2012
--


WorkingSpec = {};

function WorkingSpec.prerequisitesPresent(specializations)
    return true;
end;

function WorkingSpec:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	
	self.workExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.workExhaustParticleSystems.workExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.workExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
	
	
	self.fistTimeRunning = true;
	self.increaseRpmDuringPloughing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.increaseRpmDuringPloughing#value"), true);
end;

function WorkingSpec:delete()
	Utils.deleteParticleSystem(self.workExhaustParticleSystems);
end;

function WorkingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WorkingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function WorkingSpec:update(dt)
	if self.fistTimeRunning and self.motor ~= nil then
		self.saveMinRpm = self.motor.minRpm;
		self.fistTimeRunning = false;
	end;
	
	self.hasPloughAttached = false;
		
	for i=1, table.getn(self.attachedImplements) do
		if SpecializationUtil.hasSpecialization(Plough, self.attachedImplements[i].object.specializations) or self.attachedImplements[i].object.ploughSound ~= nil or (self.attachedImplements[i].object.tedderSound == nil and self.attachedImplements[i].object.windrowerSound == nil and self.attachedImplements[i].object.spraySound == nil) then
			if self.attachedImplements[i].object:isLowered(false) then
				self.hasPloughAttached = true;
			end;
		end;
	end;
		
	if self.hasPloughAttached and self.lastSpeed*3600 > 5 then
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, true);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, true);
	else
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, false);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, false)
	end;	
end;
	
function WorkingSpec:draw()
end;

function WorkingSpec:setVehicleRpmUp(dt, isActive)
	if self.saveMinRpm ~= 0 and self.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt/2), -800);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*2), self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		if self.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function WorkingSpec:onDeactivate()
	if self.increaseRpmDuringPloughing then
		self:setVehicleRpmUp(nil, false);
	end;
end;

WorkingSpec = {};

function WorkingSpec.prerequisitesPresent(specializations)
    return true;
end;

function WorkingSpec:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	
	self.workExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.workExhaustParticleSystems.workExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.workExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
	
	
	self.fistTimeRunning = true;
	self.increaseRpmDuringPloughing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.increaseRpmDuringPloughing#value"), true);
end;

function WorkingSpec:delete()
	Utils.deleteParticleSystem(self.workExhaustParticleSystems);
end;

function WorkingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WorkingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function WorkingSpec:update(dt)
	if self.fistTimeRunning and self.motor ~= nil then
		self.saveMinRpm = self.motor.minRpm;
		self.fistTimeRunning = false;
	end;
	
	self.hascultivatorAttached = false;
		
	for i=1, table.getn(self.attachedImplements) do
		if SpecializationUtil.hasSpecialization(cultivator, self.attachedImplements[i].object.specializations) or self.attachedImplements[i].object.cultivatorSound ~= nil or (self.attachedImplements[i].object.tedderSound == nil and self.attachedImplements[i].object.windrowerSound == nil and self.attachedImplements[i].object.spraySound == nil) then
			if self.attachedImplements[i].object:isLowered(false) then
				self.hascultivatorAttached = true;
			end;
		end;
	end;
		
	if self.hascultivatorAttached and self.lastSpeed*3600 > 5 then
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, true);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, true);
	else
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, false);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, false)
	end;	
end;
	
function WorkingSpec:draw()
end;

function WorkingSpec:setVehicleRpmUp(dt, isActive)
	if self.saveMinRpm ~= 0 and self.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt/2), -800);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*2), self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		if self.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function WorkingSpec:onDeactivate()
	if self.increaseRpmDuringPloughing then
		self:setVehicleRpmUp(nil, false);
	end;
end;

WorkingSpec = {};

function WorkingSpec.prerequisitesPresent(specializations)
    return true;
end;

function WorkingSpec:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	
	self.workExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.workExhaustParticleSystems.workExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.workExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
	
	
	self.fistTimeRunning = true;
	self.increaseRpmDuringPloughing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.increaseRpmDuringPloughing#value"), true);
end;

function WorkingSpec:delete()
	Utils.deleteParticleSystem(self.workExhaustParticleSystems);
end;

function WorkingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WorkingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function WorkingSpec:update(dt)
	if self.fistTimeRunning and self.motor ~= nil then
		self.saveMinRpm = self.motor.minRpm;
		self.fistTimeRunning = false;
	end;
	
	self.hassowingMachineAttached = false;
		
	for i=1, table.getn(self.attachedImplements) do
		if SpecializationUtil.hasSpecialization(sowing, self.attachedImplements[i].object.specializations) or self.attachedImplements[i].object.sowingSound ~= nil or (self.attachedImplements[i].object.tedderSound == nil and self.attachedImplements[i].object.windrowerSound == nil and self.attachedImplements[i].object.spraySound == nil) then
			if self.attachedImplements[i].object:isLowered(false) then
				self.hassowingMachineAttached = true;
			end;
		end;
	end;
		
	if self.hassowingMachineAttached and self.lastSpeed*3600 > 5 then
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, true);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, true);
	else
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, false);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, false)
	end;	
end;
	
function WorkingSpec:draw()
end;

function WorkingSpec:setVehicleRpmUp(dt, isActive)
	if self.saveMinRpm ~= 0 and self.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt/2), -800);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*2), self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		if self.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function WorkingSpec:onDeactivate()
	if self.increaseRpmDuringPloughing then
		self:setVehicleRpmUp(nil, false);
	end;
end;

WorkingSpec = {};

function WorkingSpec.prerequisitesPresent(specializations)
    return true;
end;

function WorkingSpec:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	
	self.workExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.workExhaustParticleSystems.workExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.workExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
	
	
	self.fistTimeRunning = true;
	self.increaseRpmDuringPloughing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.increaseRpmDuringPloughing#value"), true);
end;

function WorkingSpec:delete()
	Utils.deleteParticleSystem(self.workExhaustParticleSystems);
end;

function WorkingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WorkingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function WorkingSpec:update(dt)
	if self.fistTimeRunning and self.motor ~= nil then
		self.saveMinRpm = self.motor.minRpm;
		self.fistTimeRunning = false;
	end;
	
	self.hasmowerAttached = false;
		
	for i=1, table.getn(self.attachedImplements) do
		if SpecializationUtil.hasSpecialization(mower, self.attachedImplements[i].object.specializations) or self.attachedImplements[i].object.mowerSound ~= nil or (self.attachedImplements[i].object.tedderSound == nil and self.attachedImplements[i].object.windrowerSound == nil and self.attachedImplements[i].object.spraySound == nil) then
			if self.attachedImplements[i].object:isLowered(false) then
				self.hasmowerAttached = true;
			end;
		end;
	end;
		
	if self.hasmowerAttached and self.lastSpeed*3600 > 5 then
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, true);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, true);
	else
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, false);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, false)
	end;	
end;
	
function WorkingSpec:draw()
end;

function WorkingSpec:setVehicleRpmUp(dt, isActive)
	if self.saveMinRpm ~= 0 and self.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt/2), -800);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*2), self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		if self.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function WorkingSpec:onDeactivate()
	if self.increaseRpmDuringPloughing then
		self:setVehicleRpmUp(nil, false);
	end;
end;