-- Frontpacker
-- Specialization for Frontpacker
--
-- @Author	FIAT80-90DT
-- @Date	12.02.12 - First Version
--			01.03.13 - Convert to FS2013


Frontpacker = {};

function Frontpacker.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Frontpacker:load(xmlFile)
	self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
	
	self.showFieldNotOwnedWarning = false;
	
	self.myDirtyFlag = self:getNextDirtyFlag();
end;

function Frontpacker:readUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        self.showFieldNotOwnedWarning = streamReadBool(streamId);
	end;
end;
   
function Frontpacker:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        streamWriteBool(streamId, self.showFieldNotOwnedWarning);
    end;
end;

function Frontpacker:delete()
end;

function Frontpacker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Frontpacker:keyEvent(unicode, sym, modifier, isDown)
end;

function Frontpacker:update(dt)
end;

function Frontpacker:updateTick(dt)
	if self:getIsActive() then
		if self.isServer then
			local showFieldNotOwnedWarning = false;
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			if terrainHeight+self.groundReferenceThreshold >= y then
				local cuttingAreasSend = {};
				for k,cuttingArea in pairs(self.cuttingAreas) do
					if self:getIsAreaActive(cuttingArea) then
						local x,y,z = getWorldTranslation(cuttingArea.start);
						if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
							local x1,_,z1 = getWorldTranslation(cuttingArea.width);
							local x2,_,z2 = getWorldTranslation(cuttingArea.height);
							table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
						else
							showFieldNotOwnedWarning = true;
						end;
					end;
				end;
				if (table.getn(cuttingAreasSend) > 0) then
					SprayerAreaEvent.runLocally(cuttingAreasSend);
					g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
				end;
			end;
			
            if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
                self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
                self:raiseDirtyFlags(self.myDirtyFlag);
            end          
		end;
	end;
end;

function Frontpacker:draw()
	if self.showFieldNotOwnedWarning then
        g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
    end;
end;

function Frontpacker:onAttach(attacherVehicle)
end;

function Frontpacker:onDetach()
end;