UpdateJointEvent = {};
UpdateJointEvent_mt = Class(UpdateJointEvent, Event);

InitEventClass(UpdateJointEvent, "UpdateJointEvent");

function UpdateJointEvent:emptyNew()
    local self = Event:new(UpdateJointEvent_mt);
    self.className="UpdateJointEvent";
    return self;
end;

function UpdateJointEvent:new(object, data)
    local self = UpdateJointEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function UpdateJointEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.updateJoint = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(UpdateJointEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function UpdateJointEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;

function UpdateJointEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(UpdateJointEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(UpdateJointEvent:new(vehicle, data));
	end;
end;

