-- xyzspain
RWPackomat = {};

function RWPackomat.prerequisitesPresent(specializations)
  return true;
end;

function RWPackomat:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.9);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
-------------------------
	-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
		local translationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation2#index"));
    if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
      
    end;
	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
      
    end;
	local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
     
    end;
	 local rotationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	    self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
      
    end;
	 local rotationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
     
    end;
	 local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

          self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
      
    end;
	 local rotationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

       self.rotation7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#rotTime"), 2)*1000;
     
    end;
		 local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
      
    end;
		 local rotationNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation9#index"));
    if rotationNode9 ~= nil then
        self.rotation9 = {};
        self.rotation9.node = rotationNode9;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#minRot"));
        self.rotation9.minRot = {};
        self.rotation9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#maxRot"));
        self.rotation9.maxRot = {};
        self.rotation9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation9#rotTime"), 2)*1000;
      
    end;
			 local rotationNode10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation10#index"));
    if rotationNode10 ~= nil then
        self.rotation10 = {};
        self.rotation10.node = rotationNode10;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation10#minRot"));
        self.rotation10.minRot = {};
        self.rotation10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation10#maxRot"));
        self.rotation10.maxRot = {};
        self.rotation10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation10#rotTime"), 2)*1000;
      
    end;
			 local rotationNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation11#index"));
    if rotationNode11 ~= nil then
        self.rotation11 = {};
        self.rotation11.node = rotationNode11;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation11#minRot"));
        self.rotation11.minRot = {};
        self.rotation11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation11#maxRot"));
        self.rotation11.maxRot = {};
        self.rotation11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation11#rotTime"), 2)*1000;
      
    end;
	    local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;

	
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
			-------------------------
				---- particulas
	self.groundParticleSystems = {};
    local groundParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.groundParticleSystems#count"), 0);
    for i=1, groundParticleSystemCount do
        local namei = string.format("vehicle.groundParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
		Utils.setEmittingState(self.groundParticleSystems,false)
		self.groundParticleSystemsdisableTime = 0;		
    end;
	
	self.groundParticleSystems1 = {};
    local groundParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.groundParticleSystems1#count"), 0);
    for i=1, groundParticleSystemCount do
        local namei = string.format("vehicle.groundParticleSystems1.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.groundParticleSystems1, namei, nodei, false, nil, self.baseDirectory)	
		Utils.setEmittingState(self.groundParticleSystems1,false)
		self.groundParticleSystems1disableTime = 0;			
    end;
	self.groundParticleSystems2 = {};
    local groundParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.groundParticleSystems2#count"), 0);
    for i=1, groundParticleSystemCount do
        local namei = string.format("vehicle.groundParticleSystems2.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.groundParticleSystems2, namei, nodei, false, nil, self.baseDirectory)	
		Utils.setEmittingState(self.groundParticleSystems2,false)
		self.groundParticleSystems2disableTime = 0;			
    end;
	-------------------------
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].groundthreshold = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#groundthreshold"), 0.2);
        self.cuttingAreas[i].groundindex = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#groundindex"));
    end;
	
	
		-------------------------
    local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	local workSound1 = getXMLString(xmlFile, "vehicle.workSound1#file");
    if workSound1 ~= nil and workSound1 ~= "" then
        workSound1 = Utils.getFilename(workSound1, self.baseDirectory); 
        self.workSound1 = createSample("workSound1");
        self.workSound1Enabled = false;
        loadSample(self.workSound1, workSound1, false);
        self.workSound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound1#pitchOffset"), 1);
        self.workSound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound1#volume"), 1);
    end;
	-------------------------
		--------------
	local sound1 = getXMLString(xmlFile, "vehicle.sound1#file");
    if sound1 ~= nil and sound1 ~= "" then
        sound1 = Utils.getFilename(sound1, self.baseDirectory); 
        self.sound1 = createSample("sound1");
        self.sound1Enabled = false;
        loadSample(self.sound1, sound1, false);
        self.sound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#pitchOffset"), 1);
        self.sound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#volume"), 1);
    end;
	
	----------
	local sound2 = getXMLString(xmlFile, "vehicle.sound2#file");
    if sound2 ~= nil and sound2 ~= "" then
        sound2 = Utils.getFilename(sound2, self.baseDirectory); 
        self.sound2 = createSample("sound2");
        self.sound2Enabled = false;
        loadSample(self.sound2, sound2, false);
        self.sound2PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#pitchOffset"), 1);
        self.sound2Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#volume"), 1);
    end;
	local sound3 = getXMLString(xmlFile, "vehicle.sound3#file");
    if sound3 ~= nil and sound3 ~= "" then
        sound3 = Utils.getFilename(sound3, self.baseDirectory); 
        self.sound3 = createSample("sound3");
        self.sound3Enabled = false;
        loadSample(self.sound3, sound3, false);
        self.sound3PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound3#pitchOffset"), 1);
        self.sound3Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound3#volume"), 1);
    end;
	
	----------------------------------
		---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	

	
	----- deep wheel
	self.deepWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deepWheel#index"));
	
	----------
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	-- self.isLowering=false;
	self.rotParts= false;
	self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel; 
	self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel; 
	self.AIon=false;
	self.isLowering=false;
	self.rotation1Max= false;
end;
function RWPackomat:delete()
	if self.workSound ~= nil then
        delete(self.workSound);
    end;
   if self.workSound1 ~= nil then
        delete(self.workSound1);
    end;
 if self.sound1 ~= nil then
        delete(self.sound1);
    end;
if self.sound2 ~= nil then
        delete(self.sound2);
    end;
if self.sound3 ~= nil then
        delete(self.sound3);
    end;
	
end;
function RWPackomat:mouseEvent(posX, posY, isDown, isUp, button)
end;
function RWPackomat:keyEvent(unicode, sym, modifier, isDown)
		if not self.isLowering then
			if sym == Input.KEY_KP_4 then
			self.translation2Max= isDown;
			end;
			if sym == Input.KEY_KP_6 then
			self.translation2Min= isDown;
			end;
			
		end;
end;
function RWPackomat:update(dt)
	
if self.attacherVehicle then

	if self: getIsActive() then 
		if InputBinding.hasEvent (InputBinding.LOWER_IMPLEMENT) then 
		self.isLowering = not self.isLowering; 
		end;
		if not self.isLowering then
			if InputBinding.hasEvent (InputBinding.RWPackomat_TRANSPORT) then 
			self.transport = not self.transport; 
			end;
			
			if not self.transport then
			if InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA) then 
			self.rotation1Max = not self.rotation1Max; 
			end;
			end;
		end;
		if InputBinding.hasEvent (InputBinding.RWPackomat_CULTIVATOR) then 
			self.cultivator = not self.cultivator; 
			end;
		if InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA3) then 
		self.rotParts = not self.rotParts; 
		end;
		
		if self.rotation1Max then
		
			if not self.sound1Enabled  and not self.AIon and self:getIsActiveForSound() then
				setSamplePitch(self.sound1, self.sound1PitchOffset);
				playSample(self.sound1, 0, self.sound1Volume, 0);
				self.sound1Enabled = true;
			end;
			local x, y, z = getRotation(self.rotation1.node);
			if z < Utils.degToRad(-110)  then
				self.rotation4Max=true;
				if self.cultivator  then
					self.rotation11Max=true;
					self.rotation10Max=false;
					self.rotation9Max=true;
					self.rotation8Max=false;
					
				else
				self.rotation8Max=false;
				self.rotation9Max=false;
				self.rotation10Max=false;
				self.rotation11Max=false;
				end;
			end;
			if z < Utils.degToRad(-120)  then
				self.rotation6Max=true;
			
			end;
			if z < Utils.degToRad(-150)  then
				self.rotation5Max=true;
			end;
			if z < Utils.degToRad(-178)  then
			
				local x,y,z = getRotation(self.wheels[1].repr);	
				setRotation(self.deepWheel,(x*-1), y, z);
				if self.sound1Enabled then ---desactivar sound1
				stopSample(self.sound1);
				self.sound1Enabled = false;
				end;
				if self.transport  then
					self.rotation3Max=true;
					self.rotation2Max=false;

				else
				self.rotation3Max=false;
				self.rotation2Max=false;
				end;
				
			end;
			
		
		else
		
			if not self.sound1Enabled  and not self.AIon and self:getIsActiveForSound() then
				setSamplePitch(self.sound1, self.sound1PitchOffset);
				playSample(self.sound1, 0, self.sound1Volume, 0);
				self.sound1Enabled = true;
			end;
			local x, y, z = getRotation(self.rotation1.node);
			if z > Utils.degToRad(-70)  then
				self.rotation5Max=false;
				if self.cultivator  then
					self.rotation11Max=false;
					self.rotation10Max=true;
					self.rotation9Max=false;
					self.rotation8Max=true;
					
				else
				self.rotation8Max=false;
				self.rotation9Max=false;
				self.rotation10Max=false;
				self.rotation11Max=false;
				end;
			end;
			if z > Utils.degToRad(-60)  then
				self.rotation6Max=false;
			end;
			if z > Utils.degToRad(-50)  then
				self.rotation4Max=false;
			end;
			if z > Utils.degToRad(-1)  then
		
				local x,y,z = getRotation(self.wheels[2].repr);	
				setRotation(self.deepWheel, x, y, z);
				if self.sound1Enabled then ---desactivar sound1
				stopSample(self.sound1);
				self.sound1Enabled = false;
				end;
				if self.transport  then
					self.rotation3Max=false;
					self.rotation2Max=true;
				else
				self.rotation3Max=false;
				self.rotation2Max=false;
				end;
				
			end;
		end;
		
---recolocar cultivador en posicion 
		if self.transport  then
				self.rotation8Max=false;
				self.rotation9Max=false;
				self.rotation10Max=false;
				self.rotation11Max=false;

		end;

	
		if self.time > self.groundParticleSystemsdisableTime then
			   Utils.setEmittingState(self.groundParticleSystems, false);
		end;	
		
		
			if self.time > self.groundParticleSystems1disableTime then
			   Utils.setEmittingState(self.groundParticleSystems1, false);
		end;
			if self.time > self.groundParticleSystems2disableTime then
			   Utils.setEmittingState(self.groundParticleSystems2, false);
		end;
		          ----------areas y particulas--------------
	if self.isLowering then
				local area = 0;	
				for k, cuttingArea in pairs(self.cuttingAreas) do
					local x,y,z = getWorldTranslation(cuttingArea.groundindex);
					local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
					
					if (k == 1   )and cuttingArea.groundindex ~= nil and terrainHeight+cuttingArea.groundthreshold >= y then
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							
							Utils.updatePloughArea (x, z, x1, z1, x2, z2); 
							
						local pixelToQm = 2048 / 8192 * 2048 / 8192; -- 8192px are mapped to 2048m
						local qm = area*pixelToQm;
						local ha = qm/10000;
						
						if self.attacherVehicle.lastSpeed*3600 > 3  then
								if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
									if self.rotation1Max then
									self.groundParticleSystems1disableTime = self.time + 40;
									Utils.setEmittingState(self.groundParticleSystems1, true)
									else
									self.groundParticleSystemsdisableTime = self.time + 40;
									Utils.setEmittingState(self.groundParticleSystems, true)
									end;
								end;
								if not self.workSoundEnabled and not self.AIon and self:getIsActiveForSound() then
									setSamplePitch(self.workSound, self.workSoundPitchOffset);
									playSample(self.workSound, 0, self.workSoundVolume, 0);
									self.workSoundEnabled = true;
								end;
						elseif self.attacherVehicle.lastSpeed*3600 < 3 then
								Utils.setEmittingState(self.groundParticleSystems, false)
								Utils.setEmittingState(self.groundParticleSystems1, false)
								 if self.workSoundEnabled then
									stopSample(self.workSound);
									self.workSoundEnabled = false;
								end;
						
						
						end;	
					end;
					if (k == 2  )and cuttingArea.groundindex ~= nil and terrainHeight+cuttingArea.groundthreshold >= y then
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							
							Utils.updateCultivatorArea (x, z, x1, z1, x2, z2); 
							
						local pixelToQm = 2048 / 8192 * 2048 / 8192; -- 8192px are mapped to 2048m
						local qm = area*pixelToQm;
						local ha = qm/10000;
						
						if self.attacherVehicle.lastSpeed*3600 > 3  then
								if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
								
									self.groundParticleSystems2disableTime = self.time + 40;
									Utils.setEmittingState(self.groundParticleSystems2, true)
																		
								end;
								if not self.workSound1Enabled and not self.AIon and self:getIsActiveForSound() then
									setSamplePitch(self.workSound1, self.workSound1PitchOffset);
									playSample(self.workSound1, 0, self.workSound1Volume, 0);
									self.workSound1Enabled = true;
								end;
						elseif self.attacherVehicle.lastSpeed*3600 < 3 then
								Utils.setEmittingState(self.groundParticleSystems2, false)
								
								 if self.workSound1Enabled then
									stopSample(self.workSound1);
									self.workSound1Enabled = false;
								end;
						
						
						end;	
					end;
				end;
	else
				Utils.setEmittingState(self.groundParticleSystems, false)
				Utils.setEmittingState(self.groundParticleSystems1, false)
				Utils.setEmittingState(self.groundParticleSystems2, false)
							 if self.workSoundEnabled then
								stopSample(self.workSound);
								self.workSoundEnabled = false;
								end;
								 if self.workSound1Enabled then
								stopSample(self.workSound1);
								self.workSound1Enabled = false;
								end;
	end;
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
	end;
	

	
end;
if self.rotation1Max ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	if self.rotation2Max ~= nil then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	if self.rotation3Max ~= nil then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
	if self.rotation4Max ~= nil then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
	if self.rotation5Max ~= nil then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;
	if self.rotation6Max ~= nil then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6Max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;
	if self.rotation7Max ~= nil then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7Max);
        setRotation(self.rotation7.node, unpack(newRot));
    end;
		if self.rotation8Max ~= nil then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
		if self.rotation9Max ~= nil then
        local x, y, z = getRotation(self.rotation9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation9.maxRot, self.rotation9.minRot, 3, self.rotation9.rotTime, dt, not self.rotation9Max);
        setRotation(self.rotation9.node, unpack(newRot));
    end;
		if self.rotation10Max ~= nil then
        local x, y, z = getRotation(self.rotation10.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation10.maxRot, self.rotation10.minRot, 3, self.rotation10.rotTime, dt, not self.rotation10Max);
        setRotation(self.rotation10.node, unpack(newRot));
    end;
		if self.rotation11Max ~= nil then
        local x, y, z = getRotation(self.rotation11.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation11.maxRot, self.rotation11.minRot, 3, self.rotation11.rotTime, dt, not self.rotation11Max);
        setRotation(self.rotation11.node, unpack(newRot));
    end;
if self.translation1Max ~= nil then
					local x, y, z = getTranslation(self.translation1.node);
					local trans = {x,y,z};
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max);
					setTranslation(self.translation1.node, unpack(newTrans));
				end;

	local doTranslate=self.translation2Max or self.translation2Min
	if self.translation2 ~= nil and doTranslate then
					local x, y, z = getTranslation(self.translation2.node);
					local trans = {x,y,z};
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2Max);
					setTranslation(self.translation2.node, unpack(newTrans));
				end;
	
	if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
				end;


	--- asignacion de libertad ejes de rotacion segun condiciones de emsamblage  0 x, 2 y ,1 z 
		
		
	
	
	
	 -- self:setJointRotLimit(self.componentJoints[8],30, 180, 4000,self.free1 == true , 2,dt);
	 -- self:setJointRotLimit(self.componentJoints[8],30, 180, 1000,self.free2 == true , 2,dt);
	 
	 
	 
	 
	 
	 
	
	-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[7];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[8];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[9];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[10];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[11];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			
		
		
		
		self:setHydraulicDirection();








end;
function RWPackomat:draw()
if self.attacherVehicle then
	if self.AIon == false then
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".1"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".2"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".5"), self.typeDesc), InputBinding.RWPackomat_CULTIVATOR);
	if not self.isLowering then
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".3"), self.typeDesc), InputBinding.RWPackomat_TRANSPORT);

		g_currentMission:addExtraPrintText(g_i18n:getText(self.vehicleType..".4"));
	
	else
	end;
	end;
else 

 
end;
end;



function RWPackomat:onAttach()
self.isLowering=false;

self.rotation7Max=true;
self.translation1Max = true;
end;
function RWPackomat:onDetach()
	if not self.rotation1Max then
	self.translation1Max = false;
	self.rotation7Max=false;
	end;
    if self.deactivateOnDetach then
        RWPackomat.onDeactivate(self);
    else
        RWPackomat.onDeactivateSounds(self)
    end;



end;


function RWPackomat:onLeave()

    if self.deactivateOnLeave then
        RWPackomat.onDeactivate(self);
    else
        RWPackomat.onDeactivateSounds(self)
    end;

end;

function RWPackomat:onDeactivate()

    RWPackomat.onDeactivateSounds(self)
   

end;

function RWPackomat:onDeactivateSounds()
 if self.workSoundEnabled then
        stopSample(self.workSound);
        self.workSoundEnabled = false;
    end;
    if self.workSound1Enabled then
        stopSample(self.workSound1);
        self.workSound1Enabled = false;
    end;
	 if self.sound1Enabled then
        stopSample(self.sound1);
        self.sound1Enabled = false;
    end;
	 if self.sound2Enabled then
        stopSample(self.sound2);
        self.sound2Enabled = false;
    end;
	 if self.sound3Enabled then
        stopSample(self.sound3);
        self.sound3Enabled = false;
    end;		
end;
function RWPackomat:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
function RWPackomat:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;
function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;
function RWPackomat :aiLower()

end; 


function RWPackomat:aiRaise()
 self.rotation1Max = not self.rotation1Max ;

end;
