--
-- AllradV4.1
-- Specialization for Allrad
--
-- V2 by modelleicher & Made by Case_IH_MxU135 | FIX and V4 by DragonLord2007/modhoster | V4.1 by Saty/forum.lsczech.cz
-- www.schwabenmodding.bplaced.net


AllradV4 = {};

function AllradV4.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AllradV4:load(xmlFile)
	self.allradState = AllradV4.allradState;

	self.AllradV4Active = false;
	 
	self.hudAllradPosX = 0.7543;
	self.hudAllradPosY = 0.30;

	self.hudAllradOverlay = Overlay:new("hudAROverlay", Utils.getFilename("textures/allRad_hud.dds", self.baseDirectory), self.hudAllradPosX, self.hudAllradPosY - 0.003, 0.2371, 0.039525);

end;

function AllradV4:delete()

end;

function AllradV4:readStream(streamId, connection)  
     self:allradState(streamReadBool(streamId), true);  
end;

function AllradV4:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.AllradV4Active);  
end;

function AllradV4:mouseEvent(posX, posY, isDown, isUp, button)
end;
function AllradV4:keyEvent(unicode, sym, modifier, isDown)
end;

function AllradV4:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.AllradV4Active = state;
end;

function AllradV4:update(dt)
    if self:getIsActiveForInput() then  
		if InputBinding.hasEvent(InputBinding.AllradV4) then
		  self:allradState(not self.AllradV4Active);
		end;
    end;	
	if self:getIsActive() then	
   		if self.AllradV4Active == true then
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 	
    end; 
end;

function AllradV4:draw()
	self.hudAllradOverlay:render();
	if self.AllradV4Active == false then
		g_currentMission:addHelpButtonText(g_i18n:getText("AllradOFF"), InputBinding.AllradV4);
		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(0, 0, 0, 1);
		renderText(self.hudAllradPosX + 0.027, self.hudAllradPosY + 0.008, 0.02, "4x4 OFF");
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("AllradON"), InputBinding.AllradV4);
		setTextBold(true);
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(1, 1, 1, 1);
		renderText(self.hudAllradPosX + 0.03, self.hudAllradPosY + 0.008, 0.02, "4x4 ON");
	end;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");	

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;

