-- Fumski (AgroTeam)
-- Data 13.07.2011
-- Specjalizacja HUD dla Autosan D46 (Zielona)
-- www.LS-Modteam.pl

Hud = {};

function Hud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Hud:load(xmlFile)

    self.hudInfoBasePosX = 0.78;
    self.hudInfoBaseWidth = 0.160;
    self.hudInfoBasePosY = 0.6;
    self.hudInfoBaseHeight = 0.200;
    self.infoPanelPath = Utils.getFilename("AgroTeam.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    self.showHudInfoBase = false;
end;

function Hud:readStream(streamId, connection)
end;
  
function Hud:writeStream(streamId, connection)
end;

function Hud:keyEvent(unicode, sym, modifier, isDown)
	if self.attacherVehicle then
		if isDown and sym == Input.KEY_f2 then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;

function Hud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hud:update(dt)
end;

function Hud:updateTick(dt)
end;

function Hud:draw()

		if self.showHudInfoBase then	
			g_currentMission:addExtraPrintText("Klawisz F2: Schowaj Info");
		else
			g_currentMission:addExtraPrintText("Klawisz F2: Wyswietl Info");
		end;

	if self.showHudInfoBase and self.attacherVehicle then
		self.hudInfoBaseOverlay:render();
	end;
  
end;

function Hud:onEnter()
end;

function Hud:onLeave()
end;

function Hud:delete()
	if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;