--
-- Animacja pasow
-- Animacja ktora wprawia w ruch pasy, gdy jest aktywna komenda [self.isTurnedOn/self.isEntered/self.isMotorStarted].
-- Autor - Grzegorz056                Date:17.05.2011r. in LS 11
-- Farming Simulator 2013 - Dawider   Date:01.07.2013r. in FS 13
--
 
anim_pasy = {};

function anim_pasy.prerequisitesPresent(specializations)
    return true
end;

function anim_pasy:load(xmlFile)
	
	self.animpasy = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.animpasy.anim_pasow(%d)", i);

        if not hasXMLProperty(xmlFile, key) then
            break;
        end;

        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.animpasy, {node=node, speed=speed});
        end;
	    i = i +1;
    end;
	
end;

function anim_pasy:delete()
end;

function anim_pasy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function anim_pasy:keyEvent(unicode, sym, modifier, isDown)
end;

function anim_pasy:update(dt)
    if self:getIsActive() then
	    if self.isTurnedOn then
	    	for _, part in pairs(self.animpasy) do
              	setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
	    	end;	
	    elseif not self.isTurnedOn then
	        for _, part in pairs(self.animpasy) do
            	setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
  	    	end;	
        end;	
    end;
end;

function anim_pasy:onLeave()
end;

function anim_pasy:onEnter()
end;

function anim_pasy:onDeactivate()
end;

function anim_pasy:draw()
end;