-- Odpalanie
-- Specialization for tractor/combine
--
-- @ By Fumski
-- @ MP Ready (18.08.2011)

OdpalanieMP = {};

function OdpalanieMP.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function OdpalanieMP:load(xmlFile)
	self.invokeIgnition = SpecializationUtil.callSpecializationsFunction("invokeIgnition");

    self.ignitionKey = false;
	self.allowedIgnition = false;  
	
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;
    local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
    if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
        aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
        self.aiMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchOffset"), 0);
        self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#radius"), 50);
        self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#innerRadius"), 10);
        self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#volume"), 1);
        self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
        link(self.components[1].node, self.aiMotorSound);
        setVisibility(self.aiMotorSound, false);
    end;
	
	-- Kopia zapasowa dzwiekow
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	
	self.isMIActor = false;
end;

function OdpalanieMP:readStream(streamId, connection)
	self.ignitionKey = streamReadBool(streamId);
	self.isMotorStarted = self.ignitionKey;
	self.steeringEnabled = self.ignitionKey;
	Utils.setEmittingState(self.exhaustParticleSystems, self.ignitionKey);
	setVisibility(self.aiMotorSound, self.ignitionKey);
	
	self.fuelConsumption = streamReadFloat32(streamId);
	self.distanceDriven = streamReadFloat32(streamId);
	self.fuelUsed = streamReadFloat32(streamId);
	self.runningTime = streamReadFloat32(streamId);
end;

function OdpalanieMP:writeStream(streamId, connection)
	streamWriteBool(streamId, self.ignitionKey);
	streamWriteFloat32(streamId, self.fuelConsumption);
	streamWriteFloat32(streamId, self.distanceDriven);
	streamWriteFloat32(streamId, self.fuelUsed);
	streamWriteFloat32(streamId, self.runningTime);
end;

function OdpalanieMP:delete()
end;

function OdpalanieMP:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OdpalanieMP:keyEvent(unicode, sym, modifier, isDown)
end;

function OdpalanieMP:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local runningTime =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#runningTime"),0);
    self.runningTime = runningTime;
    local distanceDriven =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#distanceDriven"),0);
    self.distanceDriven = distanceDriven;
	local fuelUsed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsed"), 0);
	self.fuelUsed = fuelUsed;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function OdpalanieMP:getSaveAttributesAndNodes(nodeIdent)
    local runningTime = Utils.getNoNil(self.runningTime, 10);
	local distanceDriven = Utils.getNoNil(self.distanceDriven, 10);
	local fuelUsed = Utils.getNoNil(self.fuelUsed, 10);
    local attributes = 'runningTime="'..string.format("%f", runningTime)..'"'..' distanceDriven="'..string.format("%f", distanceDriven)..'"'..' fuelUsed="'..string.format("%f", fuelUsed)..'"';
    return attributes, nil;
end;

function OdpalanieMP:update(dt)
    acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
    if InputBinding.isAxisZero(acceleration) then
        acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;

	if self.isMotorStarted then
	    local kmMs = self.lastSpeed*self.speedDisplayScale / 1000;
		self.distanceDriven = self.distanceDriven + (kmMs * dt);
	    self.runningTime = self.runningTime + (dt / 1000 / 60 / 60);
		self.fuelConsumption = (self.lastMovedDistance*self.fuelUsage / dt) * 1000 * 60 * 60;
		self.fuelUsed = self.fuelUsed + self.lastMovedDistance*self.fuelUsage;
	end;
	
	-- Nie dziala, kiedy AI jest aktywne
    if not self.isAITractorActivated then
        -- Dane ModDesc
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.Odpalanie) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
			
			-- Wlaczenie silnika po nacisnieciu klawisza "W"
			if math.abs(acceleration) > 0.3 and self.isMotorStarted == false then
			    self.ignitionKey = true;
				self.allowedIgnition = true;
			end;
	    end;
		
	    -- Wycisza dzwiek kiedy silnik jest aktywny
	    if not self.ignitionKey or not self.deactivateOnLeave then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
        if self.ignitionKey and self.allowedIgnition then	
			OdpalanieMPEvent.sendEvent(self, true);
		    self:startMotor();
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true);
		elseif not self.ignitionKey and self.allowedIgnition then
			OdpalanieMPEvent.sendEvent(self, false);
		    if self.motorStopSoundVolume == 0 then
			    self.motorStopSoundVolume = self.motorStopSoundVolume2;
			end;
			
			self:stopMotor();
			self.allowedIgnition = false;
	        self.steeringEnabled = true;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
			
			-- Blokada tylnich kol po wylaczeniu silnika
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
			self:onDeactivateAttachements();
		end;
		
    -- Zapobiega AI, gdy silnik jest wylaczony
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
end;

function OdpalanieMP:onLeave()
    if not self.deactivateOnLeave then
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.allowedIgnition = false;
		self.isMotorStarted = true;
		self.ignitionKey = true; 
		self.steeringEnabled = false;
		setVisibility(self.aiMotorSound, true);
		
		-- Blokada tylnich kol po wylaczeniu silnika
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
	else
		self.allowedIgnition = false;
		self.isMotorStarted = false;
		self.ignitionKey = false;
	end;
	
	if self.isMIActor then
		-- Aktualizacja statystyk dla innych klientow
		OdpalanieMPStatsEvent.sendEvent(self);
		self.isMIActor = false;
	end;
end;

function OdpalanieMP:onEnter()
	self.isMIActor = self.isEntered;

	-- Zapobiega uruchomieniu silnika po wejsciu
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = true;
		Utils.setEmittingState(self.exhaustParticleSystems, false);
	else
	    self.steeringEnabled = true;
	end;
	
	if self.isEntered then
		setVisibility(self.aiMotorSound, false);
	else
		setVisibility(self.aiMotorSound, self.ignitionKey);
	end;
end;

function OdpalanieMP:draw()
	if self.ignitionKey then	
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ZGAS"), self.typeDesc), InputBinding.Odpalanie);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ODPAL"), self.typeDesc), InputBinding.Odpalanie);
	end;
end;

function OdpalanieMP:invokeIgnition(isRunning)
	if self.ignitionKey ~= isRunning then
		self.ignitionKey = isRunning;
		if isRunning then
			self:startMotor();
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true);
			setVisibility(self.aiMotorSound, true);
		else
			self:stopMotor();
			self.allowedIgnition = false;
			self.steeringEnabled = true;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
		end;
	end;
end;