--
-- Used
-- Specialization for Used functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - Changed xml-reading, added updateInterval to define updating interval for vehicles with many usedComponents (performance issue)
--				v3.0 - added network support, changed update to updateTick
--

Used = {};

function Used.prerequisitesPresent(specializations)
    return true;
end;

function Used:load(xmlFile)

	self.increaseUsed = SpecializationUtil.callSpecializationsFunction("increaseUsed");
	self.unusualUsedIncrease = SpecializationUtil.callSpecializationsFunction("unusualUsedIncrease");
	
	local i = 0;
	self.usedComponents = {};
	while true do
		local path = string.format("vehicle.used.usedComponent(%d)", i);
		local component = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));	
		if component == nil then
			break;
		end;
		table.insert(self.usedComponents, component);
		i = i + 1;
	end;	
	
	self.usedUpdateInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.used#updateInterval"), 0.05);
	self.usedInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.used#usedInterval"), 1) * 60 * 60 * 1000;

	self.usedScale = 0;
	self.oldUsedScale = self.usedScale;
	self.timeScale = 1;

end;

function Used:readStream(streamId, connection)
    local usedScale = streamReadFloat32(streamId);
    self:unusualUsedIncrease(usedScale);
end;

function Used:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.usedScale);
end;

function Used:delete()
end;

function Used:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Used:keyEvent(unicode, sym, modifier, isDown)
end;

function Used:update(dt)
end;

function Used:updateTick(dt)
    if self:getIsActive() or self.isActive then
        self:increaseUsed(dt);
    end;
	
	if math.abs(self.usedScale-self.oldUsedScale) > self.usedUpdateInterval then
		for i=1, table.getn(self.usedComponents) do
			setShaderParameter(self.usedComponents[i], "usedScale", self.usedScale, 0,0,0,false);
		end;
		self.oldUsedScale = self.usedScale;
	end;
end;

function Used:draw()
end;


function Used:unusualUsedIncrease(increase)
	if self.usedScale < 1 then
		self.usedScale = self.usedScale + increase;
		if self.usedScale > 1 then
			self.usedScale = 1;
		end;
	end;
end;

function Used:increaseUsed(dt)
	if self.usedScale > 1 then
		self.usedScale = 1;
	end;
	if self.usedScale < 1 then
		local scale = Utils.getMovedLimitedValues({self.usedScale}, {1}, {0}, 1, self.usedInterval*self.timeScale, dt, false);
		self.usedScale = scale[1];
	end;
end;

function Used:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.usedScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#usedLevel"),0);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Used:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'usedLevel="'.. tostring(self.usedScale) .. '"';
    return attributes, nil;
end;