--
-- Specialization for the trailer Pronar T023
--
-- @autor: Burner, Koper, Ziuta (Ziut, xXx, ja_pizgam)
-- @wielka pomoc: Burner, Koper
-- @data: 17.09.2013
--
--

Pronar_T023 = {}

function Pronar_T023.prerequisitesPresent(specializations)
    return true
end

function Pronar_T023:load(xmlFile)
	self.startRozsTime = 0
	self.getIsFoldAllowed = Utils.overwrittenFunction(self.getIsFoldAllowed, Pronar_T023.getIsFoldAllowed)
	self.SetRozsuwanie = SpecializationUtil.callSpecializationsFunction("SetRozsuwanie")
	self.rozsuwanieAnimation = getXMLString(xmlFile, "vehicle.rozsuwanie#animationName")
	self.rozsuwanie = true
	self.info = false
	self.infoTime = 0
	self.bought = true
end

function Pronar_T023:delete()
end

function Pronar_T023:readStream(streamId, connection)
	local rozsuwanieAnimationTime = streamReadFloat32(streamId)
	self:setAnimationTime(self.rozsuwanieAnimation, rozsuwanieAnimationTime)
	self:SetRozsuwanie(streamReadBool(streamId), true)
end

function Pronar_T023:writeStream(streamId, connection)
	streamWriteBool(streamId, self.rozsuwanie)
end

function Pronar_T023:readUpdateStream(streamId, timestamp, connection)
end

function Pronar_T023:writeUpdateStream(streamId, connection, dirtyMask)
end

function Pronar_T023:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
            local rozsuwanieAnimationTime = getXMLFloat(xmlFile, key.."#rozsuwanieAnimTime")
			if rozsuwanieAnimationTime == nil then
				rozsuwanieAnimationTime = self.startRozsTime
			end
            self:setAnimationTime(self.rozsuwanieAnimation, rozsuwanieAnimationTime)
			self.bought = false;
		end
    end

    return BaseMission.VEHICLE_LOAD_OK
end

function Pronar_T023:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ''
    if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
        local rozsuwanieAnimationTime = self:getAnimationTime(self.rozsuwanieAnimation)
        attributes = attributes..' rozsuwanieAnimTime="'..rozsuwanieAnimationTime..'"'
	end
    return attributes, nil
end

function Pronar_T023:mouseEvent(posX, posY, isDown, isUp, button)
end

function Pronar_T023:keyEvent(unicode, sym, modifier, isDown)
end

function Pronar_T023:update(dt)

	if self.bought == true then
		self:setAnimationTime(self.rozsuwanieAnimation, 1)
		self.bought = nil
		self.rozsuwanie = false
		Foldable.setAnimTime(self, 1)
	end;

	if self:getIsActiveForInput() then
		if self:getIsFoldAllowed() then
			if InputBinding.hasEvent(InputBinding.przedluzenie) then
				if self.foldAnimTime == 0 then
					self:SetRozsuwanie(not self.rozsuwanie)
				else
					self.info = true
				end
			end
		end
	end

	if self.info then
		self.infoTime = self.infoTime + dt
		if self.infoTime > 2000 then
			self.info = false
			self.infoTime = 0
		end
	end
end

function Pronar_T023:updateTick(dt)
end

function Pronar_T023:SetRozsuwanie(rozsuwanieState,noEventSend)
	SetRozsuwanieEvent.sendEvent(self, rozsuwanieState, noEventSend)
	if rozsuwanieState then
		if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rozsuwanieAnimation, -1, nil, true)
			self.rozsuwanie = true
		end;
	else
		if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rozsuwanieAnimation, 1, nil, true)
			self.rozsuwanie = false
		end
	end
end

function Pronar_T023:draw()
	if not self.rozsuwanie then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozsuwanie"), self.typeDesc), InputBinding.przedluzenie)
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zsuwanie"), self.typeDesc), InputBinding.przedluzenie)
	end

	if self.info then
		g_currentMission:addWarning(g_i18n:getText("uwaga"))
	end
end

function Pronar_T023:getIsFoldAllowed()
	if self:getAnimationTime(self.rozsuwanieAnimation) < 1 and self:getAnimationTime(self.rozsuwanieAnimation) > 0 then
		return false
	end
	return true
 end

--
--
--

SetRozsuwanieEvent = {}
SetRozsuwanieEvent_mt = Class(SetRozsuwanieEvent, Event)

InitEventClass(SetRozsuwanieEvent, "SetRozsuwanieEvent")

function SetRozsuwanieEvent:emptyNew()
    local self = Event:new(SetRozsuwanieEvent_mt)
    self.className="SetRozsuwanieEvent"
    return self
end

function SetRozsuwanieEvent:new(vehicle, rozsuwanieState)
    local self = SetRozsuwanieEvent:emptyNew()
    self.vehicle = vehicle
	self.rozsuwanieState = rozsuwanieState
    return self
end

function SetRozsuwanieEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
	self.rozsuwanieState = streamReadBool(streamId)
    self.vehicle = networkGetObject(id)
    self:run(connection)
end

function SetRozsuwanieEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle))
	streamWriteBool(streamId, self.rozsuwanieState)
end

function SetRozsuwanieEvent:run(connection)
	self.vehicle:SetRozsuwanie(self.rozsuwanieState, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRozsuwanieEvent:new(self.vehicle, self.rozsuwanieState), nil, connection, self.vehicle)
    end
end

function SetRozsuwanieEvent.sendEvent(vehicle, rozsuwanieState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRozsuwanieEvent:new(vehicle, rozsuwanieState), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(SetRozsuwanieEvent:new(vehicle, rozsuwanieState))
		end
	end
end
