--
-- Pickup
-- Specialization for Pickup functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		30/09/10
--

Pickup = {};

function Pickup.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Pickup:load(xmlFile)

	self.setIsPickupDown = SpecializationUtil.callSpecializationsFunction("setIsPickupDown");
	
	self.pickup = {};
	self.pickup.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.pickup#minRotLimit"))};
	self.pickup.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.pickup#maxRotLimit"))};
	self.pickup.rotTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pickup#rotTime"),2) * 1000;
	self.pickup.rake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pickup#rake"));
	self.pickup.drum = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pickup#drum"));
	self.pickup.currentRot = {0};
	self.pickup.movingDirection = 0;
	self.pickup.isDown = false;
end;

function Pickup:delete()
end;

function Pickup:readStream(streamId, connection)
    local isDown = streamReadBool(streamId);
    self:setIsPickupDown(isDown, true);
end;

function Pickup:writeStream(streamId, connection)
    streamWriteBool(streamId, self.pickup.isDown);
end;

function Pickup:readUpdateStream(streamId, timestamp, connection)
end;

function Pickup:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Pickup:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Pickup:keyEvent(unicode, sym, modifier, isDown)
end;

function Pickup:update(dt)	
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:setIsPickupDown(not self.pickup.isDown);
		end;
    end;
end;

function Pickup:updateTick(dt)	
	if self:getIsActive() then	
		if self.isTurnedOn then
			rotate(self.pickup.rake, -0.01 * dt, 0, 0);
		end;

		if self.fillLevel >= self.capacity then
			self.pickup.isDown = false;
		end;		
		
		if self.isServer then
			local newRotLimit = Utils.getMovedLimitedValues(self.pickup.currentRot, self.pickup.maxRot, self.pickup.minRot, 1, self.pickup.rotTime, dt, not self.pickup.isDown);
			if math.abs(newRotLimit[1] - self.pickup.currentRot[1]) > 0.001 then	
				setJointRotationLimit(self.componentJoints[1].jointIndex, 0, true, 0, newRotLimit[1]);		
			end;		
			self.pickup.currentRot = newRotLimit;
		end;
	end;	
end;

function Pickup:draw()
	if self.pickup.isDown then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LIFT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_LOWER"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
    end;	
end;

function Pickup:setIsPickupDown(isDown, noEventSend)
    SetIsPickupDownEvent.sendEvent(self, isDown, noEventSend);
    self.pickup.isDown = isDown;
end;


function Pickup:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
        return superFunc(self, area) and self.pickup.isDown;
    end;
	return self.pickup.isDown;
	
end;