--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

barrelPlaceable = {};
barrelPlaceable_mt = Class(barrelPlaceable, Placeable);
InitObjectClass(barrelPlaceable, "barrelPlaceable");

function barrelPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, barrelPlaceable_mt);
    registerObjectClassName(self, "barrelPlaceable");
    return self;
end;

function barrelPlaceable:delete()
    removeTrigger(self.GasTriggerId);
    unregisterObjectClassName(self);
    barrelPlaceable:superClass().delete(self);
end;

function barrelPlaceable:deleteFinal()
    barrelPlaceable:superClass().deleteFinal(self);
end;

function barrelPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not barrelPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.GasTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.GasTrigger#index"));
    GasStation:onCreate(self.GasTriggerId);
    delete(xmlFile);
    return true;
end;

function barrelPlaceable:update(dt)
end;
registerPlaceableType("barrelPlaceable", barrelPlaceable);