--
-- Pickup.lua
-- rotate Pickup Rake/Cutter when active, visible PU PS for loading Grass or Straw
--
-- author: Brndi
-- date: 21.01.2013
-- version: v1.0 (January 2013)

-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!

Pickup = {};

function Pickup.prerequisitesPresent(specializations)
	return 	SpecializationUtil.hasSpecialization(Fillable, specializations) and
			SpecializationUtil.hasSpecialization(ForageWagon, specializations);
end;

function Pickup:load(xmlFile)	

	self.Rake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Pickup.Rake#index"));
	self.Cutter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Pickup.Cutter#index"));

	if self.isClient then
		self.grassParticleSystems = {};
		local i=0;
		while true do
			local key = string.format("vehicle.PickupParticleSystems.Grass(%d)", i);
			local node = getXMLString(xmlFile, key.. "#node");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local psFile = getXMLString(xmlFile, key.. "#file");
				local grassParticleSystem = {};
				grassParticleSystem.particleSystem = {};
				StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
				table.insert(self.grassParticleSystems, grassParticleSystem);
			end;
			i = i+1;
		end;

		self.strawParticleSystems = {};
		local i=0;
		while true do
			local key = string.format("vehicle.PickupParticleSystems.Straw(%d)", i);
			local node = getXMLString(xmlFile, key.. "#node");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local psFile = getXMLString(xmlFile, key.. "#file");
				local strawParticleSystem = {};
				strawParticleSystem.particleSystem = {};
				StaticParticleSystem.loadParticleSystem(xmlFile, strawParticleSystem.particleSystem, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
				table.insert(self.strawParticleSystems, strawParticleSystem);
			end;
			i = i+1;
		end;
	end;
	
	self.fillLevelold = self.fillLevel;
	
	self.psFillcontrol = false;
	self.psStrawactive = false;
	self.psGrassactive = false;
	
end;

function Pickup:delete()	
	
	for _, ps in pairs(self.grassParticleSystems) do
		Utils.deleteParticleSystem(ps.particleSystem, false);
	end;
	for _, ps in pairs(self.strawParticleSystems) do
		Utils.deleteParticleSystem(ps.particleSystem, false);
	end;
	
end;

function Pickup:readStream(streamId, connection)
end;

function Pickup:writeStream(streamId, connection)
end;

function Pickup:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Pickup:keyEvent(unicode, sym, modifier, isDown)
end;

function Pickup:update(dt)

	if self.isTurnedOn then	
		rotate(self.Rake, -0.01 * dt, 0, 0);
		rotate(self.Cutter, -0.01 * dt, 0, 0); 
--	end;
	
-- Grass PS activate
	
--	if self.isTurnedOn then	
		if self.psFillcontrol then
			if (self.currentFillType == Fillable.FILLTYPE_GRASS_WINDROW or self.currentFillType == Fillable.FILLTYPE_DRYGRASS_WINDROW) then
				self.psGrassactive = true;
			else
				self.psGrassactive = false;
			end;	
		else
			self.psGrassactive = false;
		end;		
--	else
--		self.psGrassactive = false;
--	end;	
	
	for _, ps in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(ps.particleSystem, self.psGrassactive);
	end;

-- Straw PS activate

--	if self.isTurnedOn then	
		if self.psFillcontrol then
			if (self.currentFillType == Fillable.FILLTYPE_WHEAT_WINDROW or self.currentFillType == Fillable.FILLTYPE_BARLEY_WINDROW) then
				self.psStrawactive = true;
			else
				self.psStrawactive = false;
			end;	
		else
			self.psStrawactive = false;
		end;		
	else
		self.psStrawactive = false;
		self.psGrassactive = false;
	end;	
	
	for _, ps in pairs(self.strawParticleSystems) do
		Utils.setEmittingState(ps.particleSystem, self.psStrawactive);
	end;
	
end;

function Pickup:updateTick(dt)	

-- check fillLevel difference to activate PS

	if self.fillLevel ~= self.fillLevelold then
		if self.fillLevel > self.fillLevelold then
			self.psFillcontrol = true;
		end;
		self.fillLevelold = self.fillLevel;
	else
		self.psFillcontrol = false;
	end; 
		
end;

function Pickup:draw()
end;

function Pickup:onDetach()
end;