--[[
PickUp Particlesystem fr Pressen oder Ladewagen.

Vorlage war hier die Claas3200.lua von TTM!

Anpassungen:				Ifko[nator]
Erstellt/angepasst am:		25.06.2013

Fix: Nun wird kein PS mehr erzeugt wenn man einen Ladewagen entleert.

Gefixt von Ifko[nator] am:	03.07.2013

Edit: 18.08.2013

Gendert wurde: StaticParticleSystem fr die KronePickupParticleSystems direkt eigebunden damit keine extra lua mehr notwendig ist.

Gendert von: Ifko[nator]

Edit: 08.12.2013

Gendert wurde: Das Script wurde mit dem Pttinger Jumbo 10000 von SFM-Modding kompatibel gemacht (nun: PoettingerJumbo10000PickupParticleSystems). Es entsteht nun kein PickUp ParticleSystem mehr wenn man den Ladewagen entleert und das PickUp angehoben ist.

Gendert von: Ifko[nator]

Dieses Script ist Freiverwendbar! Sollt es ja auch nutzen.. ^^

Fr fragen bin ich via PN: 

auf www.ls-mapsource.de als "Ifko" 

oder auf www.modding-welt.com als "Ifkonator" zu erreichen.
]]

PoettingerJumbo10000PickupParticleSystems = {};

function  PoettingerJumbo10000PickupParticleSystems.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Pickup, specializations);
end;

function  PoettingerJumbo10000PickupParticleSystems:load(xmlFile)
	self.KronePresse= SpecializationUtil.callSpecializationsFunction("KronePresse");
	
	self.wheatParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.PoettingerJumbo10000PickupParticleSystems.Straw(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local wheatParticleSystem = {};
			wheatParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, wheatParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.wheatParticleSystems, wheatParticleSystem);
		end;
		i = i+1;
	end;
	
	self.grassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.PoettingerJumbo10000PickupParticleSystems.Grass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local grassParticleSystem = {};
			grassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.grassParticleSystems, grassParticleSystem);
		end;
		i = i+1;
	end;
	
	self.dryGrassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.PoettingerJumbo10000PickupParticleSystems.dryGrass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local dryGrassParticleSystem = {};
			dryGrassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, dryGrassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.dryGrassParticleSystems, dryGrassParticleSystem);
		end;
		i = i+1;
	end;
	
end;

function  PoettingerJumbo10000PickupParticleSystems:delete()
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
	end;
end;

function  PoettingerJumbo10000PickupParticleSystems:mouseEvent(posX, posY, isDown, isUp, button)
end;

function  PoettingerJumbo10000PickupParticleSystems:keyEvent(unicode, sym, modifier, isDown)
end;

function  PoettingerJumbo10000PickupParticleSystems:update(dt)
end;

function  PoettingerJumbo10000PickupParticleSystems:updateTick(dt)
	if  self.previousLevel ~= self.fillLevel then
		Utils.setEmittingState(self.dustParticles, true);
		self.previousLevel = self.fillLevel;
		self:KronePresse(4, true);
	else
		Utils.setEmittingState(self.dustParticles, false);
		self:KronePresse(4, false);
	end;
end;
	
function  PoettingerJumbo10000PickupParticleSystems:draw()
end;

function PoettingerJumbo10000PickupParticleSystems:KronePresse(mode, state, noEventSend)
  if  mode == 4 and self.isTurnedOn and self.pickup.isDown then
	if  state then
		if FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_WHEAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_BARLEY
		or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_OAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_RYE
		or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_TRITICALE then 
			for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
				Utils.setEmittingState(wheatParticleSystem.particleSystem, true);
			end;
		elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_GRASS then
			for k, grassParticleSystem in pairs(self.grassParticleSystems) do
				Utils.setEmittingState(grassParticleSystem.particleSystem, true);
			end;
		elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_DRYGRASS or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_GREENWHEAT then
			for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
				Utils.setEmittingState(dryGrassParticleSystem.particleSystem, true);
			end;
		end;
	else
		for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
			Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
		end;
		for k, grassParticleSystem in pairs(self.grassParticleSystems) do
			Utils.setEmittingState(grassParticleSystem.particleSystem, false);
		end;
		for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
			Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
		end;
	end;
  end;	
end;

-------------------------------------------------------------------------------------------------------------------------------------
-- StaticParticleSystem fr die PoettingerJumbo10000PickupParticleSystems

StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
	local defaultLinkNode = component;
	local isStatic = Utils.getNoNil(isStaticParticle, false);
	local posStr = getXMLString(xmlFile, baseString .. "#position");
    local rotStr = getXMLString(xmlFile, baseString .. "#rotation");
	if type(component) == "table" then
		defaultLinkNode = component[1].node;
	end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);
	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = defaultParticleSystem;
	end
	if psFile == nil then
		return;
	end
	psFile = Utils.getFilename(psFile, directory);
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("Error: failed to load particle system ".. psFile);
		return;
	end
	link(linkNode, rootNode);
	if posStr ~= nil and rotStr ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posStr);
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotStr);
		if posStr ~= nil and rotStr ~= nil then
			rotX = Utils.degToRad(rotX);
			rotY = Utils.degToRad(rotY);
			rotZ = Utils.degToRad(rotZ);
			setTranslation(rootNode, posX, posY, posZ);
			setRotation(rootNode, rotX, rotY, rotZ);
		end;
	end;
	for i=0, getNumOfChildren(rootNode)-1 do
		local child = getChildAt(rootNode, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					table.insert(particleSystemTable, {geometry = geometry, shape = child});
					if currentEmittingState ~= nil then
						setEmittingState(geometry, currentEmittingState);
					end;
				end;
			end;
		end;
	end;
	return rootNode;
end;