--
-- PoettingerJumbo10000
-- Specialization for PoettingerJumbo10000 functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		30/09/10
--

PoettingerJumbo10000 = {};

function PoettingerJumbo10000.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(TowBall, specializations);
end;

function PoettingerJumbo10000:load(xmlFile)

	self.rightSteering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#leftSteering"));
	self.leftSteering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#rightSteering"));
	-- find correct moving parts
	for k,part in pairs(self.movingParts) do
		if self.rightSteering == part.referencePoint then
			self.rightSteering = part;
		elseif self.leftSteering == part.referencePoint then
			self.leftSteering = part;
		end;
	end;	
	self.rightFixPointBackup = self.rightSteering.referencePoint;
	self.leftFixPointBackup = self.leftSteering.referencePoint;
	
	self.leftGuideRoller = {};
	self.leftGuideRoller.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#leftGuideRoller"));
	local ax, ay, az = getWorldTranslation(self.leftGuideRoller.node);
	local bx, by, bz = getWorldTranslation(self.leftSteering.node);
	local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.leftGuideRoller.size = distance;
	local fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#fixPoint"));
	local cx,cy,cz = getWorldTranslation(fixPoint);
	self.leftGuideRoller.distance = Utils.vector3Length(cx-bx, cy-by, cz-bz);
	self.rightGuideRoller = {};
	self.rightGuideRoller.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#rightGuideRoller"));
	ax, ay, az = getWorldTranslation(self.rightGuideRoller.node);
	bx, by, bz = getWorldTranslation(self.rightSteering.node);
	self.leftGuideRoller.size = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hayBase#index"));
	self.hayBase.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#unloadingSpeed"), 0.001);
	self.hayBase.loadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#loadingSpeed"), 0.0005);
	self.hayBase.speed = self.hayBase.loadingSpeed;
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hayBase#unloadingDirection"), 1);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	
	self.doTractorFixPointSearch = true;
end;

function PoettingerJumbo10000:delete()
end;

function PoettingerJumbo10000:readStream(streamId, connection)
end;

function PoettingerJumbo10000:writeStream(streamId, connection)
end;

function PoettingerJumbo10000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PoettingerJumbo10000:keyEvent(unicode, sym, modifier, isDown)
end;

function PoettingerJumbo10000:update(dt)
	if self:getIsActive() then		
		if self.doTractorFixPointSearch and self.leftFixPoint ~= nil and self.rightFixPoint ~= nil then
			self.rightSteering.referencePoint = self.rightFixPoint;
			self.leftSteering.referencePoint = self.leftFixPoint;			
			self.doTractorFixPointSearch  = false;
		end;
		for k, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;		
	end;
end;


function PoettingerJumbo10000:updateTick(dt)	

	if self:getIsActive() then
		local x,y,z = worldDirectionToLocal(self.rootNode, localDirectionToWorld(self.attacherVehicle.rootNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x < 0 then
			angle = -angle;
		end;
		backAngle  = 24 * (angle / 50);
		setRotation(self.leftGuideRoller.node, backAngle, 0,0);
		setRotation(self.rightGuideRoller.node, -backAngle, 0,0);

		if self.fillLevel >= self.capacity and self.isTurnedOn then
			self:setIsTurnedOn(false);
		end;
	end;
end;

function PoettingerJumbo10000:draw()	
end;

function PoettingerJumbo10000:onAttach(attacherVehicle)
	self.doJointSearch = true;
end;

function PoettingerJumbo10000:onDetach()
	self.doTractorFixPointSearch = true;
	self.leftSteering.referencePoint = self.leftFixPointBackup;
	self.rightSteering.referencePoint = self.rightFixPointBackup;
	PoettingerJumbo10000.onDeactivate(self);
end;

function PoettingerJumbo10000:onDeactivate()
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
end;

function PoettingerJumbo10000:onStartTip(currentTipTrigger, noEventSend)
	self:setIsTurnedOn(true);
	setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.unloadingSpeed,0,0,0,false);
end;

function PoettingerJumbo10000:onEndTip(noEventSend)
	self:setIsTurnedOn(false);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
end;

function PoettingerJumbo10000:setIsTurnedOn(turnedOn, noEventSend)
	if turnedOn then			
		setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.loadingSpeed,0,0,0,false);
	else
		setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	end;
end;