SetTedderStateEvent = {};
SetTedderStateEvent_mt = Class(SetTedderStateEvent, Event);

InitEventClass(SetTedderStateEvent, "SetTedderStateEvent");

function SetTedderStateEvent:emptyNew()
    local self = Event:new(SetTedderStateEvent_mt);
    self.className="SetTedderStateEvent";
    return self;
end;

function SetTedderStateEvent:new(object, state)
    local self = SetTedderStateEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetTedderStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetTedderStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.state);
end;

function SetTedderStateEvent:run(connection)
    self.object:setTedderState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTedderStateEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetTedderStateEvent.sendEvent(vehicle, state, noEventSend)
    if state ~= vehicle.tedderState then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetTedderStateEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetTedderStateEvent:new(vehicle, state));
            end;
        end;
    end;
end;

