-- FencelineSpreadingSystem
-- Specialization for tedders to work on fenceline
--
-- @author Tobias F. (John Deere 6930)
-- @date 10/07/2013
--

FencelineSpreadingSystem = {};

FencelineSpreadingSystem.TEDDERSTATE_MIDDLEROT = 0;
FencelineSpreadingSystem.TEDDERSTATE_MAXLIMITROTATION = 1;

FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_LEFT = 2;
FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_RIGHT = 3;

function FencelineSpreadingSystem.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function FencelineSpreadingSystem:load(xmlFile)
    self.setTedderState = SpecializationUtil.callSpecializationsFunction("setTedderState");	
    self.updateWheelSteeringAngel = SpecializationUtil.callSpecializationsFunction("updateWheelSteeringAngel");	

	self.fencelineSpreadingSystem = {};
	self.fencelineSpreadingSystem.leftMaxRotAnimation = getXMLString(xmlFile, "vehicle.fencelineSpreadingSystem#leftMaxRotAnimation");
    self.fencelineSpreadingSystem.leftMaxRotAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fencelineSpreadingSystem#leftMaxRotAnimationSpeed"), 1);
	
	self.fencelineSpreadingSystem.rightMaxRotAnimation = getXMLString(xmlFile, "vehicle.fencelineSpreadingSystem#rightMaxRotAnimation");
    self.fencelineSpreadingSystem.rightMaxRotAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fencelineSpreadingSystem#rightMaxRotAnimationSpeed"), 1);
	
	self.fencelineSpreadingSystem.rotLimitAnimation = getXMLString(xmlFile, "vehicle.fencelineSpreadingSystem#rotLimitAnimation");
    self.fencelineSpreadingSystem.rotLimitAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fencelineSpreadingSystem#rotLimitAnimationSpeed"), 1);
	
	self.tedderState = 0;
	
	self.fencelineWheels =  {};
	local count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fencelineSpreadingSystem.wheels#count"), 0);
	for i=1, count do
		local baseString = string.format("vehicle.fencelineSpreadingSystem.wheels.wheel%d", i);
		local entry = {};
		local wheelIndex = getXMLInt(xmlFile, baseString.."#wheelIndex");
		entry.wheel = self.wheels[wheelIndex+1];
		entry.leftMaxRot = Utils.getRadiansFromString(getXMLString(xmlFile, baseString.."#leftMaxRot"), 1);
		entry.rightMaxRot = Utils.getRadiansFromString(getXMLString(xmlFile, baseString.."#rightMaxRot"), 1);
		entry.steeringAngle = 0;
		self.fencelineWheels[i] = entry;
	end;
end;

function FencelineSpreadingSystem:delete()
end;

function FencelineSpreadingSystem:readStream(streamId, connection)
end;

function FencelineSpreadingSystem:writeStream(streamId, connection)
end;

function FencelineSpreadingSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FencelineSpreadingSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function FencelineSpreadingSystem:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			local state = 0;
			if self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXLIMITROTATION then
				state = FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_LEFT;
			elseif self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_LEFT then
				state = FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_RIGHT;
			elseif self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_RIGHT then
				state = FencelineSpreadingSystem.TEDDERSTATE_MAXLIMITROTATION;			
			end;			
			self:setTedderState(state);
		end;
	end;
	
	if self:getIsActive() then
		if self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXLIMITROTATION then		
			if self.tedderStateDirty then
				self:playAnimation(self.fencelineSpreadingSystem.leftMaxRotAnimation, -self.fencelineSpreadingSystem.leftMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rightMaxRotAnimation, -self.fencelineSpreadingSystem.rightMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rotLimitAnimation, self.fencelineSpreadingSystem.rotLimitAnimationSpeed, nil);
				for k,v in pairs(self.fencelineWheels) do
					v.wheel.steeringAngle = 0;
				end;
				self.tedderStateDirty = false;
			end;
		elseif self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_LEFT then
			if self.tedderStateDirty then
				self:playAnimation(self.fencelineSpreadingSystem.leftMaxRotAnimation, self.fencelineSpreadingSystem.leftMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rightMaxRotAnimation, -self.fencelineSpreadingSystem.rightMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rotLimitAnimation, -self.fencelineSpreadingSystem.rotLimitAnimationSpeed, nil);			
				self.tedderStateDirty = false;
			end;
			--to left
			if self.isServer then
				for k,v in pairs(self.fencelineWheels) do
					v.wheel.steeringAngle = v.leftMaxRot[1];
					setWheelShapeProps(v.wheel.node, v.wheel.wheelShape, 0, 0, v.wheel.steeringAngle);
				end;
			end;
			--
		elseif self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_RIGHT then
			if self.tedderStateDirty then
				self:playAnimation(self.fencelineSpreadingSystem.leftMaxRotAnimation, -self.fencelineSpreadingSystem.leftMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rightMaxRotAnimation, self.fencelineSpreadingSystem.rightMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rotLimitAnimation, -self.fencelineSpreadingSystem.rotLimitAnimationSpeed, nil);			
				self.tedderStateDirty = false;
			end;
			--left to right
			if self.isServer then
				for k,v in pairs(self.fencelineWheels) do
					v.wheel.steeringAngle = v.rightMaxRot[1];
					setWheelShapeProps(v.wheel.node, v.wheel.wheelShape, 0, 0, v.wheel.steeringAngle);
				end;
			end;
			--
		else
			if self.tedderStateDirty then
				self:playAnimation(self.fencelineSpreadingSystem.leftMaxRotAnimation, -self.fencelineSpreadingSystem.leftMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rightMaxRotAnimation, -self.fencelineSpreadingSystem.rightMaxRotAnimationSpeed, nil);
				self:playAnimation(self.fencelineSpreadingSystem.rotLimitAnimation, -self.fencelineSpreadingSystem.rotLimitAnimationSpeed, nil);			
				self.tedderStateDirty = false;
			end;
			--to 0
			for k,v in pairs(self.fencelineWheels) do
				v.wheel.steeringAngle = 0;
			end;
		end;
	end;
end;

function FencelineSpreadingSystem:updateTick(dt)
end;

function FencelineSpreadingSystem:updateWheelSteeringAngel(wheel, maxRot, minRot, rotTime)
end;

function FencelineSpreadingSystem:draw()
	if self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXLIMITROTATION then
        g_currentMission:addHelpButtonText(g_i18n:getText("fencelineSpreadingSystem_left"), InputBinding.IMPLEMENT_EXTRA3);
	elseif self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_LEFT then
        g_currentMission:addHelpButtonText(g_i18n:getText("fencelineSpreadingSystem_right"), InputBinding.IMPLEMENT_EXTRA3);
	elseif self.tedderState == FencelineSpreadingSystem.TEDDERSTATE_MAXROTLIMIT_RIGHT then
        g_currentMission:addHelpButtonText(g_i18n:getText("fencelineSpreadingSystem_deactivate"), InputBinding.IMPLEMENT_EXTRA3);
	end;
end;

function FencelineSpreadingSystem:setTedderState(state, noEventSend)
	SetTedderStateEvent.sendEvent(self, state, noEventSend)
	self.tedderState = state;
	self.tedderStateDirty = true;
end;

function FencelineSpreadingSystem:onSetLowered(lowered)
	if lowered then
		self:setTedderState(FencelineSpreadingSystem.TEDDERSTATE_MAXLIMITROTATION);
	else
		self:setTedderState(FencelineSpreadingSystem.TEDDERSTATE_MIDDLEROT);
	end;
end;