SetPSstateEvent = {};
SetPSstateEvent_mt = Class(SetPSstateEvent, Event);

InitEventClass(SetPSstateEvent, "SetPSstateEvent");

function SetPSstateEvent:emptyNew()
    local self = Event:new(SetPSstateEvent_mt);
    self.className = "SetPSstateEvent";
    return self;
end;

function SetPSstateEvent:new(object, state)
    local self = SetPSstateEvent:emptyNew()
    self.object = object;
	--self.states = {};
	self.state = state;
    return self;
end;

function SetPSstateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetPSstateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetPSstateEvent:run(connection)
	self.object:setPSstate(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetPSstateEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetPSstateEvent.sendEvent(vehicle, state, noEventSend)
	if vehicle.psState ~= state then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetPSstateEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetPSstateEvent:new(vehicle, state));
			end;
		end;
	end;
end;

