SetLiftUpEvent = {};
SetLiftUpEvent_mt = Class(SetLiftUpEvent, Event);

InitEventClass(SetLiftUpEvent, "SetLiftUpEvent");

function SetLiftUpEvent:emptyNew()
    local self = Event:new(SetLiftUpEvent_mt);
    self.className = "SetLiftUpEvent";
    return self;
end;

function SetLiftUpEvent:new(object, state)
    local self = SetLiftUpEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetLiftUpEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetLiftUpEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetLiftUpEvent:run(connection)
	self.object:setLiftUp(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetLiftUpEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetLiftUpEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.alpMot.setLiftUp then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetLiftUpEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetLiftUpEvent:new(vehicle, state));
			end;
		end;
	end;
end;

